% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_graph.R
\name{render_graph}
\alias{render_graph}
\title{Render the graph in various formats}
\usage{
render_graph(graph, output = NULL, layout = NULL, title = NULL,
  width = NULL, height = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{output}{a string specifying the output type;
\code{graph} (the default) renders the graph using
the \code{grViz} function, \code{vivagraph}
renders the graph using the \code{vivagraph}
function, and \code{visNetwork} renders the graph
using the \code{visnetwork} function.}

\item{layout}{a string specifying a layout type for
a \code{vivagraph} rendering of the graph, either
\code{forceDirected} or \code{constant}.}

\item{title}{an optional title for a graph when
using \code{output = "graph"}.}

\item{width}{an optional parameter for specifying
the width of the resulting graphic in pixels.}

\item{height}{an optional parameter for specifying
the height of the resulting graphic in pixels.}
}
\description{
Using a \code{dgr_graph} object,
render the graph in the RStudio Viewer.
}
\examples{
\dontrun{
# Set a seed
set.seed(24)

# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 26,
    type = "basic",
    shape = sample(c("circle", "square"),
                   length(1:26),
                   replace = TRUE),
    fillcolor = sample(c("aqua", "orange",
                         "pink", "lightgreen",
                         "black", "yellow"),
                       length(1:26),
                       replace = TRUE))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = sample(1:26, replace = TRUE),
    to = sample(1:26, replace = TRUE),
    rel = "to_node")

# Create a graph object using the ndf and edf
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Render the graph using Graphviz
render_graph(graph)

# Render the graph using VivaGraph
render_graph(graph, output = "vivagraph")

# Render the graph using visNetwork
render_graph(graph, output = "visNetwork")
}
}

