% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear_selection.R
\name{clear_selection}
\alias{clear_selection}
\title{Clear a selection of nodes or edges in a graph}
\usage{
clear_selection(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Clear the selection of nodes or edges
within a graph object.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph with nodes and edges
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Select nodes with IDs `1` and `3`
graph <-
  select_nodes(
    graph = graph,
    nodes = c(1, 3))

# Verify that a node selection has been made
get_selection(graph)
#> [1] 1 3

# Clear the selection with `clear_selection()`
graph <- clear_selection(graph)

# Verify that the node selection has been cleared
get_selection(graph)
#> [1] NA
}

