% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cycle.R
\name{add_cycle}
\alias{add_cycle}
\title{Add a cycle of nodes to the graph}
\usage{
add_cycle(graph, n, type = NULL, label = TRUE, rel = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of nodes comprising the cycle.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node cycle.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a node cycle to the graph.
}
\examples{
# Create a new graph and add a cycle of nodes to it
graph <-
  create_graph() \%>\%
  add_cycle(6)

# Get node information from this graph
node_info(graph)
#>   id type label deg indeg outdeg loops
#> 1  1 <NA>     1   2     1      1     0
#> 2  2 <NA>     2   2     1      1     0
#> 3  3 <NA>     3   2     1      1     0
#> 4  4 <NA>     4   2     1      1     0
#> 5  5 <NA>     5   2     1      1     0
#> 6  6 <NA>     6   2     1      1     0
}

