% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_node_attrs.R
\name{join_node_attrs}
\alias{join_node_attrs}
\title{Join new node attribute values using a data frame}
\usage{
join_node_attrs(graph, df, by_graph = NULL, by_df = NULL)
}
\arguments{
\item{graph}{a graph object of class}

\item{df}{the data frame to use for joining.}

\item{by_graph}{optional specification of the column
in the graph's internal node data frame for the left
join. If both \code{by_graph} and \code{by_df} are
not provided, then a natural join will occur if
there are columns in the graph's ndf and in
\code{df} with identical names.}

\item{by_df}{optional specification of the column in
\code{df} for the left join. If both \code{by_graph}
and \code{by_df} are not provided, then a natural
join will occur if there are columns in the graph's
ndf and in \code{df} with identical names.
\code{dgr_graph} that is created using
\code{create_graph}.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Join new node attribute values in a
left join using a data frame. The use of a left join
in this function allows for no possibility that
nodes in the graph might be removed after the join.
}
\examples{
library(magrittr)

# Create a simple graph
graph <-
  create_graph() \%>\%
  add_n_nodes(5) \%>\%
  add_edges_w_string("1->2 1->3 2->4 2->5 3->5")

# Create a data frame with node ID values and a
# set of numeric values
df <- data.frame(nodes = 1:6, values = rnorm(6, 5))

# Join the values in the data frame to the
# graph's nodes; this works as a left join using
# identically-named columns in the graph and the df
# (in this case `nodes` is common to both)
graph <-
  graph \%>\% join_node_attrs(df)

# Get the graph's internal ndf to show that the
# join has been made
get_node_df(graph)
#>   nodes type label           values
#> 1     1            4.27988818205506
#> 2     2             5.3499594040959
#> 3     3            5.43965531750004
#> 4     4            3.50233363164518
#> 5     5            5.04599475422798
}

