% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_info.R
\name{edge_info}
\alias{edge_info}
\title{Get detailed information on edges}
\usage{
edge_info(graph)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph}.}
}
\value{
a data frame containing information specific to each edge within
the graph.
}
\description{
Obtain a data frame with detailed information on edges and
their interrelationships within a graph.
}
\examples{
# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = LETTERS,
    label = TRUE,
    type = c(rep("a_to_g", 7),
             rep("h_to_p", 9),
             rep("q_to_x", 8),
             rep("y_and_z",2)))

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = sample(LETTERS, replace = TRUE),
    to = sample(LETTERS, replace = TRUE),
    rel = "letter_to_letter")

# Create a graph using the ndf and edf
graph <-
  create_graph(
    nodes_df = nodes,
    edges_df = edges)

# Get a data frame with information on the edges
# of the graph
edge_info(graph)
#>    from   to              rel
#> 1     A    Z letter_to_letter
#> 2     H    U letter_to_letter
#> 3     W    O letter_to_letter
#> 4     U    K letter_to_letter
#> 5     I    V letter_to_letter
#>..   ...  ...              ...
}

