% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vivagraph.R
\name{vivagraph}
\alias{vivagraph}
\title{Render graph with VivaGraphJS}
\usage{
vivagraph(graph = NULL, layout = "forceDirected", positions = NULL,
  config = NULL, height = NULL, width = NULL, elementId = NULL)
}
\arguments{
\item{graph}{a \code{dgr_graph} object, created using the \code{create_graph}
function.}

\item{layout}{a \code{string} where \code{"forceDirected"} is the default
whereas \code{"constant"} is another layout option.}

\item{positions}{\code{data.frame} of two columns \code{x} and \code{y} with
fixed positions if you intend to provide preset positions for nodes.}

\item{config}{\code{list} of other config options. While currently this does
nothing, we expect to add additional configuration options here.}

\item{height}{\code{string} or \code{integer} with a valid CSS \code{height}
for the container for our htmlwidget.}

\item{width}{\code{string} or \code{integer} with a valid CSS \code{width}
for the container for our htmlwidget.}

\item{elementId}{\code{string} with a valid CSS \code{id}.}
}
\description{
Render a graph object with the VivaGraphJS library.
}
\examples{
\dontrun{
# Create a graph using the \\code{create_nodes}, \\code{create_edges},
# and \\code{create_graph} functions
nodes <-
  create_nodes(nodes = LETTERS,
               type = "letter",
               shape = sample(c("circle", "rectangle"),
                              length(LETTERS),
                              replace = TRUE),
               fillcolor = sample(c("aqua", "gray80",
                                    "pink", "lightgreen",
                                    "azure", "yellow"),
                                  length(LETTERS),
                                  replace = TRUE))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               rel = "letter_to_letter")

graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges,
               graph_attrs = "layout = neato",
               node_attrs = c("fontname = Helvetica",
                              "style = filled"),
               edge_attrs = c("color = gray20",
                              "arrowsize = 0.5"))

vivagraph(graph = graph)
}
}

