% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfrac.R
\name{qfrac}
\alias{qfrac}
\title{Fractional Probability of Death}
\usage{
qfrac(x, s, k, i, data, assumption, prop)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{s}{An integer. Fraction of the year.}

\item{k}{An integer. Number of fractions per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame containing the mortality table, with the first column being the age and the second one, the probability of death.}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths and "constant" for constant force of mortality).}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}
}
\value{
The fractional probability of death.
}
\description{
Calculates the fractional probability for a person of x+s/k dies before age x+(s+1)/k.
}
\examples{
qfrac(27,1,4,0.04,CSO80MANB,"constant",1)
qfrac(20,0,12,0.04,CSO80MANB,"UDD",1)
}
\keyword{Fractional}
\keyword{death}
\keyword{of}
\keyword{probability}
