% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PremiumFrac.R
\name{PremiumFrac}
\alias{PremiumFrac}
\title{Fractional Premium}
\usage{
PremiumFrac(px1, x, m, k, i = 0.04, data, prop = 1, effect = "yes", assumption)
}
\arguments{
\item{px1}{A numeric type value. The value of the single net premium.}

\item{x}{An integer. The age of the insuree.}

\item{m}{An integer. Years of premium payment.}

\item{k}{An integer. Number of premiums per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table used (between 0 and 1).}

\item{effect}{A character string. This parameter indicates if, in the event of death, the insuree is released from paying the remaining fractional premiums of that year ("yes" or "no")}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths and "constant" for constant force of mortality).}
}
\value{
Returns the annualized value of the fractional premium.
}
\description{
Calculates the annualized value of the fractional premiums.
}
\note{
If k=1, regardless of the "effect", the returned value is the annual premium.
}
\examples{
PremiumFrac(1000,20,10,2,0.04,CSO80MANB,1,"yes","constant")
PremiumFrac(1000,20,10,2,0.04,CSO80MANB,1,"no","UDD")

}
\references{
Chapter 4 of  Actuarial Mathematics for Life Contingent Risks (2009) by Dickson, Hardy and Waters
}
\keyword{Fractional}
\keyword{Premium}
