% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A..R
\name{A.}
\alias{A.}
\title{Life Insurance}
\usage{
A.(x, h, n, k = 1, i = 0.04, data, prop = 1, assumption = "none", cap = 1)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of fractions per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{cap}{A numeric type value. The value of the payment.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of the life insurance.
}
\examples{
A.(50,0,8,1,0.04,CSO80MANB,1,"none",1)
A.(60,3,10,1,0.04,CSO80MANB,1,"none",1)
A.(21,4,7,3,0.04,CSO80MANB,1,"constant",1)
A.(23,4,6,12,0.04,CSO80MANB,1,"UDD",1)

}
\references{
Chapter 3 of  Life Contingencies (1952) by Jordan, chapter 4 of  Actuarial Mathematics (1997) by Bowers, Gerber, Hickman, Jones & Nesbitt.
}
\keyword{Insurance}
\keyword{Life}
