% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_ensemble.R
\name{pattc_ensemble}
\alias{pattc_ensemble}
\title{PATT_C SL Ensemble}
\usage{
pattc_ensemble(
  response.formula,
  exp.data,
  pop.data,
  treat.var,
  compl.var,
  compl.SL.learners = c("SL.glmnet", "SL.xgboost", "SL.ranger", "SL.nnet", "SL.glm"),
  response.SL.learners = c("SL.glmnet", "SL.xgboost", "SL.ranger", "SL.nnet", "SL.glm"),
  ID = NULL,
  cluster = NULL,
  binary.outcome = FALSE,
  bootstrap = FALSE,
  nboot = 1000
)
}
\arguments{
\item{response.formula}{formula for the effects of covariates on outcome
variable (y ~ x).}

\item{exp.data}{\code{data.frame} object for experimental data. Must include
binary treatment and compliance variable.}

\item{pop.data}{\code{data.frame} object for population data. Must include
binary compliance variable.}

\item{treat.var}{string for binary treatment variable.}

\item{compl.var}{string for binary compliance variable.}

\item{compl.SL.learners}{vector of names of ML algorithms used for compliance
model.}

\item{response.SL.learners}{vector of names of ML algorithms used for response
model.}

\item{ID}{string for name of identifier. (currently not used)}

\item{cluster}{string for name of cluster variable. (currently not used)}

\item{binary.outcome}{logical specifying predicted outcome variable will take
binary values or proportions.}

\item{bootstrap}{logical for bootstrapped PATT-C.}

\item{nboot}{number of bootstrapped samples. Only used with
\code{bootstrap = FALSE}}
}
\value{
\code{pattc_ensemble} object of results of t test as PATTC estimate.
}
\description{
\code{pattc_ensemble} estimates the Population Average Treatment Effect
of the Treated from experimental data with noncompliers
using the super learner ensemble that includes extreme gradient boosting,
glmnet (elastic net regression), random forest and neural nets.
}
\examples{
\donttest{
# load datasets
data(exp_data_full) # full experimental data
data(exp_data) #experimental data
data(pop_data) #population data
#attach SuperLearner (model will not recognize learner if package is not loaded)
library(SuperLearner)
set.seed(123456)
#specify models and estimate PATTC
pattc <- pattc_ensemble(response.formula = support_war ~ age + income +
                                education + employed + job_loss,
                                exp.data = exp_data_full,
                                pop.data = pop_data,
                                treat.var = "strong_leader",
                                compl.var = "compliance",
                                compl.SL.learners = c("SL.glm", "SL.nnet"),
                                response.SL.learners = c("SL.glm", "SL.nnet"),
                                ID = NULL,
                                cluster = NULL,
                                binary.outcome = FALSE)

print(pattc)

pattc_boot <- pattc_ensemble(response.formula = support_war ~ age + income +
                                education + employed + job_loss,
                                exp.data = exp_data_full,
                                pop.data = pop_data,
                                treat.var = "strong_leader",
                                compl.var = "compliance",
                                compl.SL.learners = c("SL.glm", "SL.nnet"),
                                response.SL.learners = c("SL.glm", "SL.nnet"),
                                ID = NULL,
                                cluster = NULL,
                                binary.outcome = FALSE,
                                bootstrap = TRUE,
                                nboot = 1000)
print(pattc_boot)

}
}
