/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.BubbleElementModel;
import edu.cens.spatial.plots.ChoroElementModel;
import edu.cens.spatial.plots.ColoredPointsElementModel;
import edu.cens.spatial.plots.LinesElementModel;
import edu.cens.spatial.plots.PlottingElement;
import edu.cens.spatial.plots.PointsElementModel;
import edu.cens.spatial.plots.PolyElementModel;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JOptionPane;
import org.rosuda.deducer.Deducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialPlotModel
extends AbstractListModel {
    private final List<PlottingElement> _components = new ArrayList<PlottingElement>();
    private double[][] _boundingBox = new double[][]{{Double.NaN, Double.NaN}, {Double.NaN, Double.NaN}};
    private String _maptype = "osm";

    public SpatialPlotModel() {
    }

    private SpatialPlotModel(Collection<PlottingElement> collection, double[][] dArray) {
        this._components.addAll(collection);
        this._boundingBox = new double[][]{(double[])dArray[0].clone(), (double[])dArray[1].clone()};
    }

    public String getCall() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PlottingElement plottingElement : this._components) {
            if (!plottingElement.isActive()) continue;
            stringBuilder.append("\n").append(plottingElement.getModel().getCall()).append("");
        }
        return stringBuilder.toString();
    }

    public SpatialPlotModel clone() {
        SpatialPlotModel spatialPlotModel = new SpatialPlotModel(this._components, this._boundingBox);
        spatialPlotModel._maptype = this._maptype;
        return spatialPlotModel;
    }

    public boolean add(PlottingElement plottingElement) {
        boolean bl = this._components.add(plottingElement);
        this.fireContentsChanged(this, this.getSize(), this.getSize());
        return bl;
    }

    public void insertElementAt(PlottingElement plottingElement, int n) {
        this._components.add(n, plottingElement);
        this.fireContentsChanged(this, n, n);
    }

    public PlottingElement remove(int n) {
        PlottingElement plottingElement = this._components.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return plottingElement;
    }

    public boolean validate() {
        return true;
    }

    @Override
    public int getSize() {
        return this._components.size();
    }

    @Override
    public PlottingElement getElementAt(int n) {
        return this._components.get(n);
    }

    public boolean executeSubsetting(double d, double d2, double d3, double d4, boolean bl, String string) {
        PlottingElement plottingElement2;
        boolean bl2 = false;
        int n = 0;
        for (PlottingElement plottingElement2 : this._components) {
            if (!plottingElement2.isActive()) continue;
            ++n;
        }
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "You have nothing to subset!", "Error", 0);
            return false;
        }
        if (n > 1) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "You may only subset 1 dataset at a time!\nPlease hide all but one dataset using the controls to the right.", "Error", 0);
            return false;
        }
        String string2 = string;
        plottingElement2 = null;
        for (PlottingElement plottingElement3 : this._components) {
            String string3;
            if (!plottingElement3.isActive()) continue;
            String string4 = plottingElement3.getModel().getDataFrameArgumentName();
            String string5 = null;
            if (plottingElement3.getModel() instanceof PolyElementModel || plottingElement3.getModel() instanceof ChoroElementModel) {
                string5 = "DeducerSpatial:::.subsetPoly";
            } else if (plottingElement3.getModel() instanceof LinesElementModel) {
                string5 = "DeducerSpatial:::.subsetLines";
            } else if (plottingElement3.getModel() instanceof PointsElementModel || plottingElement3.getModel() instanceof ColoredPointsElementModel || plottingElement3.getModel() instanceof BubbleElementModel) {
                string5 = "DeducerSpatial:::.subsetPoints";
            } else {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, "Subsetting is not currently supported for plots of type \"" + plottingElement3.getModel().getClass() + "\".", "Error", 0);
                return false;
            }
            if (string4 == null) continue;
            String string6 = bl ? "FALSE" : "TRUE";
            String string7 = string3 = (String)string2 + " <- " + string4 + "\n" + (String)string2 + " <- " + string5 + "(" + d + "," + d2 + "," + d3 + "," + d4 + "," + string4 + "," + "removeSelection=" + string6 + ")";
            string7.replace("\n", "\\n");
            System.out.println();
            Deducer.timedEval((String)("cat(\"" + string7 + "\\n\")"));
            Deducer.timedEval((String)string3);
            if (Deducer.timedEval((String)string2).isNull()) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, "Your subset contains no elements! reverting to original plot.+\nIf you want to remove this component from the plot, you must use the controls at right.", "Warning", 2);
                bl2 = false;
                continue;
            }
            plottingElement2 = plottingElement3;
            bl2 = true;
        }
        if (bl2) {
            plottingElement2.getModel().setDataFrameArgumentName(string);
        }
        return bl2;
    }
}

