/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.DeducerSpatial;
import edu.cens.spatial.plots.BubbleElementModel;
import edu.cens.spatial.plots.ChoroElementModel;
import edu.cens.spatial.plots.ColoredPointsElementModel;
import edu.cens.spatial.plots.DeviceInterface;
import edu.cens.spatial.plots.LinesElementModel;
import edu.cens.spatial.plots.PlottingElement;
import edu.cens.spatial.plots.PointsElementModel;
import edu.cens.spatial.plots.PolyElementModel;
import edu.cens.spatial.plots.PolygonLabelsElementModel;
import edu.cens.spatial.plots.SpatialPlotModel;
import edu.cens.spatial.plots.TextElementModel;
import edu.cens.spatial.plots.ViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.javaGD.GDContainer;
import org.rosuda.javaGD.PlotPanel;

public class SpatialPlotBuilder
extends TJFrame
implements ActionListener,
WindowListener {
    private static final String HELP_URL = "http://www.deducer.org/pmwiki/index.php?n=Main.SpatialPlotBuilder";
    private final JLayeredPane _pane = new JLayeredPane();
    private final JPanel _rightPanel = new JPanel();
    private final JPanel _topPanel = new JPanel();
    private final OkayCancelPanel _okayCancel = new OkayCancelPanel(true, true, (ActionListener)this);
    private final JTabbedPane _addTabs = new JTabbedPane();
    private final JList _elementsList = new JList();
    private final JPanel _shadow = new JPanel();
    private final JPanel _background = new JPanel();
    private final JPanel _plotHolder = new JPanel();
    private PlotPanel _device;
    private Map<String, ListModel> _addElementListModels = new LinkedHashMap<String, ListModel>();
    private SpatialPlotModel _model;
    private static SpatialPlotModel _lastModel;
    private JCheckBoxMenuItem _axes1 = new JCheckBoxMenuItem("Axes");
    private ButtonGroup _backgroundGroup = new ButtonGroup();
    private ViewPanel _vp;
    private boolean firstPlot = true;
    private JTextField _titleField = new JTextField();
    private static boolean _fromMain;

    public SpatialPlotBuilder() {
        this(_lastModel == null ? new SpatialPlotModel() : _lastModel.clone());
    }

    public SpatialPlotBuilder(SpatialPlotModel spatialPlotModel) {
        super("Spatial Builder", false, 1911);
        try {
            this.setModel(spatialPlotModel);
            this.init();
            this.initGUI();
            this.updatePlot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() {
        DefaultListModel<PlottingElement> defaultListModel = (DefaultListModel<PlottingElement>)this._addElementListModels.get("Spatial");
        if (defaultListModel == null) {
            defaultListModel = new DefaultListModel<PlottingElement>();
            this._addElementListModels.put("Spatial", defaultListModel);
        }
        defaultListModel.addElement(new PlottingElement(new PointsElementModel()));
        defaultListModel.addElement(new PlottingElement(new ColoredPointsElementModel()));
        defaultListModel.addElement(new PlottingElement(new BubbleElementModel()));
        defaultListModel.addElement(new PlottingElement(new TextElementModel()));
        defaultListModel.addElement(new PlottingElement(new LinesElementModel()));
        defaultListModel.addElement(new PlottingElement(new PolyElementModel()));
        defaultListModel.addElement(new PlottingElement(new PolygonLabelsElementModel()));
        defaultListModel.addElement(new PlottingElement(new ChoroElementModel()));
        DeducerSpatial.rgdalCheck();
    }

    private void initGUI() {
        int n = 155;
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            AnchorLayout anchorLayout = new AnchorLayout();
            this._pane.setLayout((LayoutManager)anchorLayout);
            this.setDefaultCloseOperation(2);
            this._topPanel.setLayout((LayoutManager)new AnchorLayout());
            this._pane.add((Component)this._topPanel, new AnchorConstraint(1, 0, 100, 0, 1, 2, 0, 1));
            this._pane.setLayer(this._topPanel, 10);
            this._topPanel.setPreferredSize(new Dimension(683, 130));
            String[] stringArray = new JPanel(new BorderLayout());
            stringArray.add((Component)this._titleField, "Center");
            stringArray.add((Component)new JLabel("Title: "), "West");
            this._pane.add((Component)stringArray, new AnchorConstraint(125, 160, 0, 25, 2, 2, 0, 2));
            this._pane.setLayer((Component)stringArray, 100);
            this._pane.add((Component)this._shadow, new AnchorConstraint(1, 1, 164, 1, 1, 2, 0, 1));
            this._pane.setLayer(this._shadow, 9);
            this._shadow.setPreferredSize(new Dimension(683, 283));
            this._shadow.setBackground(new Color(105, 105, 105));
            this._shadow.setVisible(false);
            this._pane.add((Component)this._background, new AnchorConstraint(0, 0, 0, 0, 2, 2, 2, 2));
            this._pane.setLayer(this._background, -1000);
            JComponent jComponent = new JPanel();
            Serializable serializable = new BorderLayout();
            jComponent.setLayout((LayoutManager)((Object)serializable));
            this._topPanel.add((Component)jComponent, new AnchorConstraint(11, 5, 996, 5, 1, 2, 1, 2));
            jComponent.setPreferredSize(new Dimension(659, 124));
            jComponent.add((Component)this._addTabs, "Center");
            this._addTabs.setPreferredSize(new Dimension(659, 130));
            for (Map.Entry<String, ListModel> entry : this._addElementListModels.entrySet()) {
                String string = entry.getKey();
                ListModel listModel = entry.getValue();
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                this._addTabs.add(string, jPanel);
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jPanel.add(jScrollPane);
                JList<Object> jList = new JList<Object>();
                jList.setCellRenderer(new DefaultListCellRenderer(){

                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        JPanel jPanel = ((PlottingElement)object).makeComponent();
                        SpatialPlotBuilder.this.setPanelBgIfSelected(jList, bl, jPanel);
                        return jPanel;
                    }
                });
                jList.setVisibleRowCount(listModel.getSize() / 7);
                jList.setLayoutOrientation(2);
                jList.setModel(listModel);
                jList.setDragEnabled(true);
                AddElementTransferHandler addElementTransferHandler = new AddElementTransferHandler();
                jList.setTransferHandler(addElementTransferHandler);
                jList.addMouseListener(new AddMouseListener());
                jList.setSelectionMode(0);
                jScrollPane.setViewportView(jList);
            }
            this._plotHolder.setLayout(new BorderLayout());
            this._plotHolder.setBorder(BorderFactory.createBevelBorder(1));
            stringArray = new JPanel();
            this._plotHolder.add((Component)stringArray, "Center");
            this._pane.add(this._plotHolder, new AnchorConstraint(n, 158, 52, 22, 2, 2, 2, 1), 2);
            this._plotHolder.setPreferredSize(new Dimension(515, 391));
            this._plotHolder.setTransferHandler(new PanelTransferHandler());
            stringArray = new AnchorLayout();
            this._rightPanel.setLayout((LayoutManager)stringArray);
            this._pane.add(this._rightPanel, new AnchorConstraint(n, 1000, 52, 731, 2, 1, 2, 0), 4);
            this._rightPanel.setPreferredSize(new Dimension(160, 389));
            jComponent = new IconButton("/icons/stop_16.png", "Remove component", (ActionListener)this, "remove");
            this._rightPanel.add((Component)jComponent, new AnchorConstraint(872, 921, 925, 540, 1, 1, 0, 0));
            jComponent.setPreferredSize(new Dimension(21, 21));
            jComponent = new IconButton("/icons/reload_16.png", "Toggle active", (ActionListener)this, "active");
            this._rightPanel.add((Component)jComponent, new AnchorConstraint(872, 578, 913, 240, 1, 0, 0, 1));
            jComponent.setPreferredSize(new Dimension(21, 21));
            jComponent = new IconButton("/icons/edit_16.png", "Edit component", (ActionListener)this, "edit");
            this._rightPanel.add((Component)jComponent, new AnchorConstraint(872, 190, 904, 100, 1, 0, 0, 1));
            jComponent.setPreferredSize(new Dimension(21, 21));
            jComponent = new JPanel();
            jComponent.setLayout(new BorderLayout());
            this._rightPanel.add((Component)jComponent, new AnchorConstraint(0, 928, 859, 90, 2, 1, 1, 1));
            jComponent.setPreferredSize(new Dimension(134, 334));
            jComponent.setBorder(BorderFactory.createTitledBorder("Components"));
            serializable = new JScrollPane();
            jComponent.add((Component)serializable, "Center");
            ((JScrollPane)serializable).setViewportView(this._elementsList);
            this._elementsList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    PlottingElement plottingElement = (PlottingElement)object;
                    JPanel jPanel = plottingElement.makeComponent();
                    if (!plottingElement.isActive()) {
                        jPanel.setBackground(Color.GRAY);
                    }
                    SpatialPlotBuilder.this.setPanelBgIfSelected(jList, bl, jPanel);
                    return jPanel;
                }
            });
            this._elementsList.setDragEnabled(true);
            this._elementsList.addListSelectionListener(new ElementListListener());
            this._elementsList.setTransferHandler(new ElementTransferHandler());
            this._elementsList.setSelectionMode(0);
            this._elementsList.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && SpatialPlotBuilder.this._elementsList.getSelectedIndex() >= 0) {
                        PlottingElement plottingElement = (PlottingElement)SpatialPlotBuilder.this._elementsList.getSelectedValue();
                        SpatialPlotBuilder.editElement(plottingElement, SpatialPlotBuilder.this);
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.maybePopup(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.maybePopup(mouseEvent);
                }

                public void maybePopup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = SpatialPlotBuilder.this._elementsList.locationToIndex(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        ElementPopupMenu.element = SpatialPlotBuilder.this._model.getElementAt(n);
                        ElementPopupMenu.elList = SpatialPlotBuilder.this._elementsList;
                        ElementPopupMenu.plot = SpatialPlotBuilder.this;
                        ElementPopupMenu.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            stringArray = new JPanel();
            jComponent = new AnchorLayout();
            stringArray.setLayout((LayoutManager)((Object)jComponent));
            this._pane.add((Component)stringArray, new AnchorConstraint(870, 1000, 1000, 0, 0, 1, 1, 1));
            stringArray.setPreferredSize(new Dimension(688, 59));
            serializable = new HelpButton("pmwiki.php?n=Main.SpatialPlotBuilder");
            serializable.setUrl(HELP_URL);
            stringArray.add((Component)serializable, new AnchorConstraint(364, 51, 0, 19, 0, 0, 2, 1));
            serializable.setPreferredSize(new Dimension(36, 36));
            stringArray.add((Component)this._okayCancel, new AnchorConstraint(500, 965, 0, 592, 0, 1, 2, 0));
            this._okayCancel.setPreferredSize(new Dimension(267, 39));
            stringArray = new String[]{"+", "File", "@N New", "new", "-", "+", "Map types", "Open street map", "osm", "Bing Aerial images", "bing", "+", "Tools", "View call", "call", "Subset", "subset", "~Window", "0"};
            jComponent = EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)new MenuListener(), (String[])stringArray);
            this.setContentPane(this._pane);
            this.pack();
            this.addWindowListener(this);
            this.setSize(705, 620);
            this.setTitle("Spatial Plot Builder");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setPanelBgIfSelected(JList jList, boolean bl, JPanel jPanel) {
        if (bl) {
            jPanel.setBackground(jList.getSelectionBackground());
            jPanel.setForeground(jList.getSelectionForeground());
        } else {
            jPanel.setBackground(jList.getBackground());
            jPanel.setForeground(jList.getForeground());
        }
    }

    public void setModel(SpatialPlotModel spatialPlotModel) {
        this._model = spatialPlotModel;
        this._elementsList.setModel(spatialPlotModel);
    }

    public SpatialPlotModel getModel() {
        return this._model;
    }

    public void openLayerSheet(PlottingElement plottingElement) {
    }

    public void closeLayerSheet() {
    }

    public String formatCall(boolean bl) {
        String string = this._model.getCall();
        if (string == null || "".equals(string)) {
            return "";
        }
        if (this._vp == null || this._model == null) {
            return "";
        }
        String string2 = "mar=c(0,0,0,0)";
        if (bl) {
            string2 = "mar=c(.5,.5,2.25,.5), oma=c(1,1,1,1)";
        }
        Vector<Double> vector = this._vp.getUpperLeftCoordinate();
        Vector<Double> vector2 = this._vp.getLowerRightCoordinate();
        String string3 = "plot.new()\npar(" + string2 + ")\nplot.window(c(" + vector.get(0) + "," + vector2.get(0) + "),c(" + vector2.get(1) + "," + vector.get(1) + "), xaxs = 'i', yaxs = 'i')";
        if (bl) {
            vector = this._vp.getUpperLeftLatLong();
            vector2 = this._vp.getLowerRightLatLong();
            int n = this._vp.getZoom();
            string3 = string3 + "\nplot(openmap(c(" + vector.get(0) + "," + vector.get(1) + "),c(" + vector2.get(0) + "," + vector2.get(1) + ")," + n + ",'" + this._vp.getTileSourceType() + "'),add=TRUE,raster=TRUE)";
        }
        string3 = string3 + string;
        if (bl && this._titleField.getText() != null) {
            string3 = string3 + "\ntitle('" + this._titleField.getText() + "')";
        }
        return string3;
    }

    public void plot(final String string) {
        if (this._device == null) {
            this._plotHolder.removeAll();
            this._device = new PlotPanel(this._plotHolder.getWidth(), this._plotHolder.getHeight());
            this._device.setTransferHandler((TransferHandler)new PanelTransferHandler());
            DeviceInterface.register((GDContainer)this._device);
            this._vp = new ViewPanel(this._device, this);
            this._plotHolder.add(this._vp);
        }
        if (string == null || "".equals(string)) {
            this._device.reset();
            this._device.repaint();
            return;
        }
        this._okayCancel.getApproveButton().setEnabled(false);
        final JLabel jLabel = new JLabel("plotting...");
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(Font.decode("Arial-BOLD-30"));
        jLabel.setForeground(Color.green);
        this._pane.add(jLabel, new AnchorConstraint(137, 158, 52, 22, 2, 2, 2, 1), 100);
        this._pane.setLayer(jLabel, 100);
        this._pane.validate();
        this._pane.repaint();
        final ViewPanel viewPanel = this._vp;
        final boolean bl = this.firstPlot;
        new Thread(new Runnable(){

            public void run() {
                try {
                    SpatialPlotBuilder.plotInternal(string, ((SpatialPlotBuilder)SpatialPlotBuilder.this)._device.devNr, bl, viewPanel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SpatialPlotBuilder.this._pane.remove(jLabel);
                        SpatialPlotBuilder.this._okayCancel.getApproveButton().setEnabled(true);
                        SpatialPlotBuilder.this._device.repaint();
                        SpatialPlotBuilder.this._pane.validate();
                    }
                });
            }
        }).start();
        this.firstPlot = false;
    }

    public static void plotInternal(String string, int n, boolean bl, ViewPanel viewPanel) {
        try {
            Deducer.timedEval((String)"Sys.setenv(\"JAVAGD_CLASS_NAME\"=\"edu/cens/spatial/plots/DeviceInterface\")");
            if (n == -1) {
                Deducer.timedEval((String)"JavaGD()");
                Deducer.timedEval((String)"par(list(bg=\"transparent\"))");
                Deducer.timedEval((String)"plot.new()");
                viewPanel.refreshPlot();
            } else {
                Deducer.timedEval((String)("dev.set(" + (n + 1) + ")"));
            }
            String string2 = string;
            Deducer.timedEval((String)string2);
            if (bl) {
                // empty if block
            }
            Deducer.timedEval((String)"Sys.setenv(\"JAVAGD_CLASS_NAME\"=\"org/rosuda/JGR/toolkit/JavaGD\")");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updatePlot() {
        if (_fromMain) {
            return;
        }
        String string = this.formatCall(false);
        this.plot(string);
    }

    public void addElement(PlottingElement plottingElement) {
        plottingElement = (PlottingElement)plottingElement.clone();
        JDialog jDialog = plottingElement.getJDialog();
        jDialog.setLocationRelativeTo((Component)((Object)this));
        jDialog.setModal(true);
        jDialog.setVisible(true);
        if (plottingElement.getModel().checkValid() == null) {
            this._model.add(plottingElement);
            if (!this._model.validate()) {
                this._model.remove(this._model.getSize());
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SpatialPlotBuilder.this.updatePlot();
                }
            });
        }
    }

    private void showComponentDialog(PlottingElement plottingElement) {
        JDialog jDialog = plottingElement.getJDialog();
        jDialog.setLocationRelativeTo((Component)((Object)this));
        jDialog.setModal(true);
        jDialog.setVisible(true);
    }

    private static void editElement(PlottingElement plottingElement, SpatialPlotBuilder spatialPlotBuilder) {
        spatialPlotBuilder.showComponentDialog(plottingElement);
        spatialPlotBuilder.updatePlot();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Run".equals(string)) {
            String string2 = this.formatCall(true);
            if (this._model.getSize() == 0 || string2 == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Plot contains no components.");
                return;
            }
            _lastModel = this._model.clone();
            if (this._device != null) {
                this._device.devOff();
                this._plotHolder.remove((Component)this._device);
                this._device = null;
            }
            Deducer.execute((String)("dev.new()\n" + string2));
            this.dispose();
        } else if ("Reset".equals(string)) {
            this.setModel(new SpatialPlotModel());
        } else if ("Cancel".equals(string)) {
            this.dispose();
        } else {
            int n = this._elementsList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            PlottingElement plottingElement = this._model.getElementAt(n);
            if ("remove".equals(string)) {
                this._model.remove(n);
            } else if ("edit".equals(string)) {
                this.showComponentDialog(plottingElement);
            } else if ("active".equals(string)) {
                plottingElement.setActive(!plottingElement.isActive());
                this._model.validate();
                this._elementsList.validate();
                this._elementsList.repaint();
            }
            this.updatePlot();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this._device != null) {
            this._device.devOff();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void beginSubsetting() {
        this.setCursorCrosshair();
        this._vp.beginSubsetting();
    }

    public void stopSubsetting() {
        this.setCursorNormal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSubsetting(final double d, final double d2, final double d3, final double d4, final boolean bl, final String string) {
        final Component component = this.getRootPane().getGlassPane();
        component.setCursor(new Cursor(3));
        component.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                SpatialPlotBuilder.this._model.executeSubsetting(d, d2, d3, d4, bl, string);
                SpatialPlotBuilder.this.updatePlot();
                component.setCursor(new Cursor(0));
                component.setVisible(false);
            }
        }).start();
    }

    public void setCursorCrosshair() {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void setCursorNormal() {
        this.setCursor(new Cursor(0));
    }

    static {
        _fromMain = false;
    }

    public class MenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (!"save".equals(string)) {
                if ("new".equals(string)) {
                    SpatialPlotBuilder spatialPlotBuilder = new SpatialPlotBuilder(new SpatialPlotModel());
                    spatialPlotBuilder.setVisible(true);
                    WindowTracker.addWindow((JFrame)((Object)spatialPlotBuilder));
                } else if ("call".equals(string)) {
                    JFrame jFrame = new JFrame("Call");
                    jFrame.setSize(700, 200);
                    jFrame.setLayout(new BorderLayout());
                    JTextArea jTextArea = new JTextArea();
                    jFrame.add(jTextArea);
                    jTextArea.setText(SpatialPlotBuilder.this.formatCall(true) + "\n");
                    jFrame.setLocationRelativeTo((Component)((Object)SpatialPlotBuilder.this));
                    jFrame.setVisible(true);
                } else if ("bing".equals(string)) {
                    SpatialPlotBuilder.this._vp.setTileSource("bing");
                } else if ("osm".equals(string)) {
                    SpatialPlotBuilder.this._vp.setTileSource("osm");
                } else if ("subset".equals(string)) {
                    SpatialPlotBuilder.this.beginSubsetting();
                }
            }
        }
    }

    static class AddElementPopupMenu {
        private static JPopupMenu popup;
        private static PlottingElement element;
        private static SpatialPlotBuilder pBuilder;

        AddElementPopupMenu() {
        }

        private static JPopupMenu getPopup() {
            if (popup == null) {
                popup = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Add");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        pBuilder.addElement((PlottingElement)element.clone());
                    }
                });
                popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Get info");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = "http://www.deducer.org";
                        if (string != null && string.length() > 0) {
                            HelpButton.showInBrowser((String)SpatialPlotBuilder.HELP_URL);
                        }
                    }
                });
                popup.add(jMenuItem);
            }
            return popup;
        }
    }

    class AddMouseListener
    implements MouseListener {
        AddMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent, true);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent, false);
        }

        public void maybePopup(MouseEvent mouseEvent, boolean bl) {
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.locationToIndex(mouseEvent.getPoint());
            if (mouseEvent.isPopupTrigger()) {
                if (n < 0) {
                    return;
                }
                AddElementPopupMenu.element = (PlottingElement)jList.getModel().getElementAt(n);
                AddElementPopupMenu.pBuilder = SpatialPlotBuilder.this;
                AddElementPopupMenu.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getClickCount() == 2 && bl) {
                PlottingElement plottingElement = (PlottingElement)jList.getModel().getElementAt(n);
                SpatialPlotBuilder.this.addElement((PlottingElement)plottingElement.clone());
            }
        }
    }

    static class ElementPopupMenu {
        private static PlottingElement element;
        private static JList elList;
        private static SpatialPlotBuilder plot;

        ElementPopupMenu() {
        }

        private static JPopupMenu getPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Edit");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SpatialPlotBuilder.editElement(element, plot);
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Toggle active");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    element.setActive(!element.isActive());
                    elList.validate();
                    elList.repaint();
                    plot.updatePlot();
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Remove");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SpatialPlotModel spatialPlotModel = plot.getModel();
                    for (int i = 0; i < spatialPlotModel.getSize(); ++i) {
                        if (element != spatialPlotModel.getElementAt(i)) continue;
                        spatialPlotModel.remove(i);
                        break;
                    }
                    plot.updatePlot();
                }
            });
            jPopupMenu.add(jMenuItem);
            return jPopupMenu;
        }
    }

    class ElementListListener
    implements ListSelectionListener {
        ElementListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class ElementTransferHandler
    extends PanelTransferHandler {
        public int lastIndex;

        ElementTransferHandler() {
            this.lastIndex = -1;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return super.canImport(jComponent, dataFlavorArray) || dataFlavorArray.length == 1 && dataFlavorArray[0].equals(PlottingElement.getFlavor());
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (super.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return super.importData(jComponent, transferable);
            }
            try {
                JList jList = (JList)jComponent;
                SpatialPlotModel spatialPlotModel = SpatialPlotBuilder.this._model;
                PlottingElement plottingElement = (PlottingElement)transferable.getTransferData(PlottingElement.getFlavor());
                if (plottingElement.getModel().checkValid() == null) {
                    return false;
                }
                int n = jList.getSelectedIndex();
                for (int i = 0; i < spatialPlotModel.getSize(); ++i) {
                    if (plottingElement != spatialPlotModel.getElementAt(i)) continue;
                    spatialPlotModel.remove(i);
                    --i;
                }
                if (n < 0) {
                    spatialPlotModel.add((PlottingElement)plottingElement.clone());
                } else {
                    spatialPlotModel.insertElementAt((PlottingElement)plottingElement.clone(), n);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SpatialPlotBuilder.this.updatePlot();
                    }
                });
                n = jList.getSelectedIndex();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            JList jList = (JList)jComponent;
            this.lastIndex = jList.getSelectedIndex();
            return this.lastIndex > -1 ? SpatialPlotBuilder.this._model.getElementAt(this.lastIndex) : null;
        }

        public Icon getVisualRepresentation(Transferable transferable) {
            try {
                PlottingElement plottingElement = (PlottingElement)transferable.getTransferData(PlottingElement.getFlavor());
                return new ImageIcon(plottingElement.getImage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    class PanelTransferHandler
    extends TransferHandler {
        PanelTransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return dataFlavorArray.length == 1 && dataFlavorArray[0].equals(PlottingElement.getFlavor());
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                PlottingElement plottingElement = (PlottingElement)transferable.getTransferData(PlottingElement.getFlavor());
                SpatialPlotBuilder.this.addElement(plottingElement);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
    }

    class AddElementTransferHandler
    extends TransferHandler {
        AddElementTransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            return false;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            try {
                JList jList = (JList)jComponent;
                return (Transferable)jList.getSelectedValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

