/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import edu.cens.spatial.CoordViewFactory;
import edu.cens.spatial.SpatialDataViewFactory;
import edu.cens.spatial.SpatialMenuListener;
import edu.cens.spatial.SpatialVariableViewFactory;
import edu.cens.spatial.plots.SpatialPlotBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.JGR;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataViewerController;
import org.rosuda.deducer.data.DataViewerTabFactory;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamColor;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionList;
import org.rosuda.ibase.toolkit.EzMenuSwing;

public class DeducerSpatial {
    public static ActionListener cListener = new SpatialMenuListener();

    public static void init() {
        try {
            if (Deducer.isJGR()) {
                int n = 6;
                DeducerSpatial.insertMenu((JFrame)JGR.MAINRCONSOLE, "Spatial", n);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Load Shape File", (String)"shape", (ActionListener)cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Load Census Data", (String)"census", (ActionListener)cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, (String)"Spatial").addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Data -> Spatial", (String)"conv_pnt", (ActionListener)cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Spatial -> Data", (String)"conv_df", (ActionListener)cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, (String)"Spatial").addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Spatial Plot Builder", (String)"builder", (ActionListener)cListener);
            }
            DataViewerController.init();
            DataViewerController.addDataType((String)"SpatialPointsDataFrame", (String)"sp-p");
            DataViewerController.addTabFactory((String)"SpatialPointsDataFrame", (String)"Data View", (DataViewerTabFactory)new SpatialDataViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPointsDataFrame", (String)"Variable View", (DataViewerTabFactory)new SpatialVariableViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPointsDataFrame", (String)"Coordinates", (DataViewerTabFactory)new CoordViewFactory(false));
            DataViewerController.addDataType((String)"SpatialPolygonsDataFrame", (String)"sp-py");
            DataViewerController.addTabFactory((String)"SpatialPolygonsDataFrame", (String)"Data View", (DataViewerTabFactory)new SpatialDataViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPolygonsDataFrame", (String)"Variable View", (DataViewerTabFactory)new SpatialVariableViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPolygonsDataFrame", (String)"Centroids", (DataViewerTabFactory)new CoordViewFactory(false));
            DataViewerController.addDataType((String)"SpatialLinesDataFrame", (String)"sp-l");
            DataViewerController.addTabFactory((String)"SpatialLinesDataFrame", (String)"Data View", (DataViewerTabFactory)new SpatialDataViewFactory());
            DataViewerController.addTabFactory((String)"SpatialLinesDataFrame", (String)"Variable View", (DataViewerTabFactory)new SpatialVariableViewFactory());
            DataViewerController.addTabFactory((String)"SpatialLinesDataFrame", (String)"Paths", (DataViewerTabFactory)new CoordViewFactory(true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean rgdalCheck() {
        if (!Deducer.isLoaded((String)"rgdal")) {
            if (Deducer.isInstalled((String)"rgdal")) {
                Deducer.execute((String)"library(rgdal)");
                return true;
            }
            int n = JOptionPane.showOptionDialog(null, "The package rgdal is required for most functionality in Deducer Spatial. Would you like to install it now?", "Install", 0, 3, null, new String[]{"Yes", "No"}, "Yes");
            if (n == 0) {
                if (System.getProperty("os.name").startsWith("Mac")) {
                    Deducer.execute((String)"setRepositories(ind=c(9,2))\ninstall.packages('rgdal')\nlibrary(rgdal)");
                } else {
                    Deducer.execute((String)"install.packages('rgdal')\nlibrary(rgdal)");
                }
            }
            return false;
        }
        return true;
    }

    public static void insertMenu(JFrame jFrame, String string, int n) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)jFrame, (String)string);
        if (jMenu == null && n < jMenuBar.getMenuCount()) {
            JMenuBar jMenuBar2 = new JMenuBar();
            int n2 = jMenuBar.getMenuCount();
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    jMenuBar2.add(new JMenu(string));
                }
                jMenuBar2.add(jMenuBar.getMenu(0));
            }
            jFrame.setJMenuBar(jMenuBar2);
        } else if (jMenu == null && n == jMenuBar.getMenuCount()) {
            EzMenuSwing.addMenu((JFrame)jFrame, (String)string);
        }
    }

    public static void main(String[] stringArray) {
        final SpatialPlotBuilder spatialPlotBuilder = new SpatialPlotBuilder();
        JPanel jPanel = new JPanel();
        jPanel.add(new JButton("subset"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        spatialPlotBuilder.beginSubsetting();
                    }
                });
            }
        });
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add((Component)spatialPlotBuilder.getContentPane(), "Center");
        jFrame.add((Component)jPanel, "South");
        jFrame.setVisible(true);
    }

    public static Param makeColorScaleParam() {
        RFunctionList rFunctionList = new RFunctionList();
        rFunctionList.setName("palette");
        rFunctionList.setTitle("Palette");
        rFunctionList.setRequired(false);
        RFunction rFunction = new RFunction("brewer_pal");
        rFunction.setTitle("Color brewer");
        ParamCharacter paramCharacter = new ParamCharacter("palette");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setValue((Object)"Blues");
        paramCharacter.setDefaultValue((Object)"Blues");
        paramCharacter.setOptions(new String[]{"YlOrRd", "YlOrBr", "YlGnBu", "YlGn", "Reds", "RdPu", "Pruples", "PuRd", "PuBuGn", "PuBu", "OrRd", "Oranges", "Greys", "Greens", "GnBu", "BuPu", "BuGn", "Blues", "", "Set3", "Set2", "Set1", "Pastel2", "Pastel1", "Paired", "Dark2", "Accent", "", "Spectral", "RdYlGn", "RdYlBu", "RdGy", "RdBu", "PuOr", "PRGn", "PiYG", "BrBG"});
        rFunction.add((Param)paramCharacter);
        rFunctionList.addRFunction("Color brewer", rFunction);
        rFunction = new RFunction("hue_pal");
        rFunction.setTitle("Hue");
        ParamVector paramVector = new ParamVector();
        paramVector.setName("h");
        paramVector.setTitle("Hue range");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        paramVector.setValue((Object)new String[]{"15", "375"});
        paramVector.setDefaultValue((Object)new String[]{"15", "375"});
        rFunction.add((Param)paramVector);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("l");
        paramNumeric.setTitle("Luminance [0, 100]");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue((Object)new Double(65.0));
        paramNumeric.setDefaultValue((Object)new Double(65.0));
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(100.0));
        rFunction.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("c");
        paramNumeric.setTitle("Chroma");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue((Object)new Double(100.0));
        paramNumeric.setDefaultValue((Object)new Double(100.0));
        paramNumeric.setLowerBound(new Double(0.0));
        rFunction.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("h.start");
        paramNumeric.setTitle("Hue start");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue((Object)new Double(0.0));
        paramNumeric.setDefaultValue((Object)new Double(0.0));
        paramNumeric.setLowerBound(new Double(0.0));
        rFunction.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("direction");
        paramNumeric.setTitle("Colour wheel direction");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramNumeric.setValue((Object)new Double(1.0));
        paramNumeric.setDefaultValue((Object)new Double(1.0));
        paramNumeric.setOptions(new String[]{"1.0", "-1.0"});
        paramNumeric.setLabels(new String[]{"clockwise", "counter clockwise"});
        rFunction.add((Param)paramNumeric);
        rFunctionList.addRFunction("Hue", rFunction);
        rFunction = new RFunction("seq_gradient_pal");
        rFunction.setTitle("Sequential");
        ParamColor paramColor = new ParamColor();
        paramColor.setName("low");
        paramColor.setTitle("Low");
        paramColor.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        paramColor.setValue((Object)Color.decode("#132B43"));
        paramColor.setDefaultValue((Object)Color.decode("#132B43"));
        rFunction.add((Param)paramColor);
        paramColor = new ParamColor();
        paramColor.setName("high");
        paramColor.setTitle("High");
        paramColor.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        paramColor.setValue((Object)Color.decode("#56B1F7"));
        paramColor.setDefaultValue((Object)Color.decode("#56B1F7"));
        rFunction.add((Param)paramColor);
        paramCharacter = new ParamCharacter();
        paramCharacter.setName("space");
        paramCharacter.setTitle("Space");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setValue((Object)"rgb");
        paramCharacter.setDefaultValue((Object)"rgb");
        paramCharacter.setOptions(new String[]{"rgb", "Lab"});
        rFunction.add((Param)paramCharacter);
        rFunctionList.addRFunction("Sequential", rFunction);
        return rFunctionList;
    }
}

