/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SideWindow
extends JFrame
implements WindowListener,
ComponentListener {
    protected Window parent;
    protected int offset = 20;
    protected boolean ordering = false;

    public SideWindow(Window window) {
        this.setUndecorated(true);
        this.parent = window;
        this.parent.addComponentListener(this);
        this.parent.addWindowListener(this);
        this.updateLocation();
        this.updateSize();
    }

    public void updateLocation() {
        Point point = this.parent.getLocationOnScreen();
        int n = this.parent.getWidth();
        this.setLocation(point.x + n, point.y + this.offset);
    }

    public void updateSize() {
        this.setSize(this.getWidth(), this.parent.getHeight() - 2 * this.offset);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        final SideWindow sideWindow = this;
        if (this.isVisible() && !this.ordering) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SideWindow.this.ordering = true;
                    sideWindow.toFront();
                    SideWindow.this.parent.toFront();
                }
            });
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        SideWindow.this.ordering = false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.updateLocation();
        this.updateSize();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.updateLocation();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateSize();
        this.updateLocation();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.parent == null || !this.parent.isVisible()) {
            super.setVisible(bl);
            return;
        }
        if (bl) {
            if (this.isVisible()) {
                return;
            }
            this.parent.toFront();
            this.updateSize();
            this.setLocation(this.parent.getLocation().x + this.parent.getWidth() - this.getWidth(), this.parent.getY() + this.offset);
            this.parent.setAlwaysOnTop(true);
            super.setVisible(true);
            this.parent.setAlwaysOnTop(false);
            int n = this.getWidth();
            int n2 = this.parent.getLocation().x + this.parent.getWidth() - n;
            int n3 = this.getY();
            while ((double)n2 < this.parent.getBounds().getMaxX() + 1.0) {
                this.setLocation(n2, n3);
                n2 += 30;
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.updateLocation();
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.parent.toFront();
            int n = this.getWidth();
            int n4 = this.getX();
            int n5 = this.getY();
            while (this.getX() + n > this.parent.getX() + this.parent.getWidth()) {
                this.setLocation(n4, n5);
                n4 -= 30;
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            super.setVisible(false);
        }
    }
}

