% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HilbertTransform.R
\name{HilbertTransform}
\alias{HilbertTransform}
\title{The Hilbert transform}
\usage{
HilbertTransform(sig)
}
\arguments{
\item{sig}{Signal to transform.}
}
\value{
asig Analytic signal
}
\description{
Creates the analytic signal using the Hilbert transform.
}
\details{
Creates the real and imaginary parts of a signal.
}
\examples{
tt   <- seq(1000) * 0.01
sig  <- sin(pi * tt)
asig <- HilbertTransform(sig)

plot(tt, sig, xlim = c(0, 12))

lines(tt, Re(asig), col = "green")
lines(tt, Im(asig), col = "red")
legend("topright", col = c("black", "green", "red"),
       lty = c(NA, 1, 1), pch = c(1, NA, NA),
       legend = c("Signal", "Real", "Imaginary"))

}
\seealso{
\code{\link{HilbertEnvelope}}, \code{\link{InstantaneousFrequency}}
}
\author{
Daniel C. Bowman (in the hht package)
}
