% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.emd.R
\name{check.emd}
\alias{check.emd}
\title{Check an EMD object}
\usage{
check.emd(emd, xy = NULL, timelimit = 15)
}
\arguments{
\item{emd}{an amd object to test}

\item{xy}{the original signal that was decomposed: this parameter is simply
to insure that you are indeed comparing the decomposition to the original
signal, and not cheating by providing the sum of your decomposition}

\item{timelimit}{a time limit for the computation of the greatest common
rational divisor. A too long time may be indicative of a problem, typically
depth/time values that are not rounded adequately.}
}
\description{
Provides an ensemble of check on the quality of a decomposition
presented as an emd object (see \code{\link{as.emd}} for more information)
}
\examples{
set.seed(50)

h <- rnorm(n = 1000)

dt <- seq_len(length(h))

alpha <- 0.95

for(i in dt[-1]) h[i] <- alpha *  h[i-1] + h[i]

set.seed(42)

em <- extricate(h, dt, nimf = 7, repl = 1, comb = 100, sifting = 4,
                factor_noise = 20, unit_noise = "native", speak = TRUE)

\dontrun{
plot_emd(em, adapt.axis = TRUE)}

check.emd(em, h)

}
