% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gzc.departure.R
\name{gzc.departure}
\alias{gzc.departure}
\title{departure of instantaneous frequency to generalized zero-crossing}
\usage{
gzc.departure(
  pulse = NULL,
  dt = NULL,
  m = NULL,
  f = NULL,
  repl = 1,
  mode = NULL,
  simplify = TRUE
)
}
\arguments{
\item{pulse}{a pulse object object}

\item{dt}{the depth or time. Is overridden by pulse.}

\item{m}{a matrix of the modes to calculate the gzc frequency from. Is
overridden by pulse.}

\item{f}{a matrix of the frequencies to compare to gzc.}

\item{repl}{the amount of replicates in m. Is overridden by emd.}

\item{mode}{the mode sequence index to give to each replicated IMFs.
Is overridden by emd.}

\item{simplify}{whether to average the value for each component of each
replicate}
}
\value{
If simplify is TRUE, the function returns the average gzc departure
as a data frame where the columns stand for the modes and the rows for the
replicates. If simplify if FALSE, the function returns the functions returns
local gzc departure.
}
\description{
departure of instantaneous frequency to generalized
zero-crossing of instantaneous freqeuncy. The departure is calculated as the
exponential of the absolute difference of logarithms
of frequencies obtained using a robust generalized zero-crossing method
through the \code{\link{gzc}} function (where the components are simplified
into extrema separated by zero-crossings) and instantaneous frequency
computed from another method
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + t * 0.01

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec1 <- extricate(xy, dt, nimf = 5, repl = 1, comb = 10, sifting = 1,
                 factor_noise = 10, bind = TRUE, speak = TRUE)

dec2 <- extricate(xy, dt, nimf = 6, repl = 1, comb = 100, sifting = 5,
                  factor_noise = 50, bind = TRUE, speak = TRUE)

\donttest{
plot_emd(dec1, name = "EMD 1", dir = tempdir())
plot_emd(dec2, name = "EMD 2", dir = tempdir())}

parsimony(dec1)
parsimony(dec2)

f1 <- inst.pulse(dec1, plot = FALSE)
f2 <- inst.pulse(dec2, plot = FALSE)

gzc.departure(f1)
gzc.departure(f2)

}
