% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condense.R
\name{condense}
\alias{condense}
\title{Condenses columns of matrix}
\usage{
condense(m, n, fun = "mean")
}
\arguments{
\item{m}{matrix of repeated signal, each column being a repetition}

\item{n}{the number of repetitions that will be averaged/summed}

\item{fun}{the function to apply to each repetition: "mean" or "sum".}
}
\value{
a matrix with n times less columns
}
\description{
Condenses columns of a matrix by averaging or summing
them. The condensing can be done partially: a multiple of the repetitions can
be averaged or summed to keep some repetitions.
}
\examples{
m <- matrix(rep(seq(100, 800, 100), each = 10) + rep(1:10, 8), ncol = 8)

m

condense(m, 4)

}
