/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.DMDResultSet;
import net.starschema.clouddb.jdbc.Logger;

class COLResultSetMetadata
implements ResultSetMetaData {
    String[][] data = null;
    String[] labels;
    static Logger logger = Logger.getLogger(COLResultSetMetadata.class.getName());
    DMDResultSet.DMDResultSetType MetaDataType;

    public COLResultSetMetadata(String[][] data, String[] labels, DMDResultSet.DMDResultSetType type) {
        this.labels = labels;
        this.data = data;
        this.MetaDataType = type;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        logger.debug("Function Call getCatalogName parameter: " + column);
        if (this.MetaDataType == DMDResultSet.DMDResultSetType.getColumns) {
            return this.data[0][0];
        }
        if (this.MetaDataType == DMDResultSet.DMDResultSetType.getSchemas) {
            return this.data[column - 1][1];
        }
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        logger.debug("Function Call getColumnClassName parameter: " + column);
        return String.class.toString();
    }

    @Override
    public int getColumnCount() throws SQLException {
        logger.debug("Function Call getColumnCount");
        return this.labels.length;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        logger.debug("Function Call getColumnDisplaySize");
        return 65536;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        logger.debug("Function Call getColumnLabel parameter: " + column);
        return this.labels[column - 1];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        logger.debug("Function Call getColumnName parameter: " + column);
        return this.labels[column - 1];
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        logger.debug("Function Call getColumnType parameter: " + column);
        return 12;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        logger.debug("Function Call getColumnTypeName parameter: " + column);
        return "VARCHAR";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        logger.debug("Function Call getPrecision parameter: " + column);
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        logger.debug("Function Call getScale parameter: " + column);
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        logger.debug("Function Call getSchemaName parameter: " + column);
        if (this.MetaDataType == DMDResultSet.DMDResultSetType.getColumns) {
            return this.data[0][1];
        }
        if (this.MetaDataType == DMDResultSet.DMDResultSetType.getSchemas) {
            return this.data[column - 1][0];
        }
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        logger.debug("Function Call getTableName parameter: " + column);
        if (this.MetaDataType == DMDResultSet.DMDResultSetType.getColumns) {
            return this.data[0][2];
        }
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        logger.debug("Function Call isAutoIncrement parameter: " + column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        logger.debug("Function Call isCaseSensitive parameter: " + column);
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        logger.debug("Function Call isCurrency parameter: " + column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        logger.debug("Function Call isDefinitelyWritable parameter: " + column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        logger.debug("Function Call getTableName parameter: " + column);
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        logger.debug("Function Call isReadOnly parameter: " + column);
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        logger.debug("Function Call isSearchable parameter: " + column);
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        logger.debug("Function Call isSigned parameter: " + column);
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        logger.debug("Function Call isWritable parameter: " + column);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new BQSQLException("not found");
    }
}

