/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import net.starschema.clouddb.jdbc.BQPreparedStatement;
import net.starschema.clouddb.jdbc.BQResultsetMetaData;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQStatement;
import net.starschema.clouddb.jdbc.BQStatementRoot;
import net.starschema.clouddb.jdbc.ScrollableResultset;

public class BQResultSet
extends ScrollableResultset<Object>
implements ResultSet {
    private int maxFieldSize = 0;
    private GetQueryResultsResponse Result = null;
    private BQStatement Statementreference = null;

    public BQResultSet(GetQueryResultsResponse bigQueryGetQueryResultResponse, BQPreparedStatement bqPreparedStatement) {
        this.Result = bigQueryGetQueryResultResponse;
        try {
            BigInteger maxrow = BigInteger.valueOf(bqPreparedStatement.getMaxRows());
            this.Result.setTotalRows(maxrow);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.maxFieldSize = bqPreparedStatement.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.RowsofResult = this.Result.getRows() == null ? null : this.Result.getRows().toArray();
    }

    public BQResultSet(GetQueryResultsResponse bigQueryGetQueryResultResponse, BQStatementRoot bqStatementRoot) {
        this.Result = bigQueryGetQueryResultResponse;
        try {
            BigInteger maxrow = BigInteger.valueOf(bqStatementRoot.getMaxRows());
            this.Result.setTotalRows(maxrow);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.maxFieldSize = bqStatementRoot.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.RowsofResult = this.Result.getRows() == null ? null : this.Result.getRows().toArray();
        if (bqStatementRoot instanceof BQStatement) {
            this.Statementreference = (BQStatement)bqStatementRoot;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        int columncount = this.getMetaData().getColumnCount();
        for (int i = 1; i <= columncount; ++i) {
            if (!this.getMetaData().getColumnName(i).equals(columnLabel)) continue;
            return i;
        }
        BQSQLException e = new BQSQLException("No Such column labeled: " + columnLabel);
        throw e;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return new BQResultsetMetaData(this.Result);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.closestrm();
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        this.ThrowCursorNotValidExeption();
        if (this.RowsofResult == null) {
            throw new BQSQLException("There are no rows in this Resultset");
        }
        if (this.getMetaData().getColumnCount() < columnIndex || columnIndex < 1) {
            throw new BQSQLException("ColumnIndex is not valid");
        }
        String Columntype = this.Result.getSchema().getFields().get(columnIndex - 1).getType();
        TableCell field = ((TableRow)this.RowsofResult[this.Cursor]).getF().get(columnIndex - 1);
        if (Data.isNull(field.getV())) {
            this.wasnull = true;
            return null;
        }
        String result = field.getV().toString();
        this.wasnull = false;
        try {
            if (Columntype.equals("STRING")) {
                if (this.maxFieldSize == 0 || this.maxFieldSize == Integer.MAX_VALUE) {
                    return result;
                }
                try {
                    return result.substring(0, this.maxFieldSize);
                }
                catch (IndexOutOfBoundsException iout) {
                    return result;
                }
            }
            if (Columntype.equals("FLOAT")) {
                return Float.valueOf(Float.parseFloat(result));
            }
            if (Columntype.equals("BOOLEAN")) {
                return Boolean.parseBoolean(result);
            }
            if (Columntype.equals("INTEGER")) {
                return Long.parseLong(result);
            }
            if (Columntype.equals("TIMESTAMP")) {
                long val = new BigDecimal(result).longValue() * 1000L;
                return new Timestamp(val);
            }
            throw new BQSQLException("Unsupported Type (" + Columntype + ")");
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.Statementreference;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.closestrm();
        this.ThrowCursorNotValidExeption();
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        String result = (String)((TableRow)this.RowsofResult[this.Cursor]).getF().get(columnIndex - 1).getV();
        this.wasnull = result == null;
        if (this.maxFieldSize == 0 || this.maxFieldSize == Integer.MAX_VALUE) {
            return result;
        }
        try {
            return result.substring(0, this.maxFieldSize);
        }
        catch (IndexOutOfBoundsException iout) {
            return result;
        }
    }
}

