/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.BQDriver;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQSupportFuncts;
import net.starschema.clouddb.jdbc.DMDResultSet;
import net.starschema.clouddb.jdbc.Logger;

class BQDatabaseMetadata
implements DatabaseMetaData {
    BQConnection Connection;
    static Logger logger = Logger.getLogger(BQDatabaseMetadata.class.getName());
    static boolean multipleOpenResultsSupported = false;

    public BQDatabaseMetadata(BQConnection bqConnection) {
        this.Connection = bqConnection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        logger.debug("Function call getAttributes catalog: " + (catalog != null ? catalog : "null") + ", schemaPattern: " + (schemaPattern != null ? schemaPattern : "null") + ", typeNamePattern:" + (typeNamePattern != null ? typeNamePattern : "null") + ", attributeNamePattern: " + (attributeNamePattern != null ? attributeNamePattern : "null"));
        logger.debug("not implemented yet returning empty resultset");
        String[] Col = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        return new DMDResultSet((Object[])new Object[0][21], Col, DMDResultSet.DMDResultSetType.getAttributes);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        logger.debug("Function call getBestRowIdentifier(String,String,String,int,boolean)");
        logger.debug("Not implemented yet returning empty resultset");
        String[] Col = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        return new DMDResultSet((Object[])new Object[0][8], Col, DMDResultSet.DMDResultSetType.getBestRowIdentifier);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        logger.debug("Function call getCatalogs()");
        try {
            List<ProjectList.Projects> Projects2 = ((ProjectList)this.Connection.getBigquery().projects().list().execute()).getProjects();
            if (Projects2 != null && Projects2.size() != 0) {
                Object[] Data2 = new String[Projects2.size()];
                String toLog = "";
                for (int i = 0; i < Projects2.size(); ++i) {
                    Data2[i] = Projects2.get(i).getId().replace(":", "__").replace(".", "_");
                    toLog = toLog + (String)Data2[i] + " , ";
                }
                logger.debug("Catalogs are: " + toLog);
                return new DMDResultSet(Data2, new String[]{"TABLE_CAT"}, DMDResultSet.DMDResultSetType.getCatalogs);
            }
            logger.debug("nothing to return");
            return new DMDResultSet(new String[]{null}, new String[]{"TABLE_CAT"}, DMDResultSet.DMDResultSetType.getCatalogs);
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public String getCatalogSeparator() throws BQSQLException {
        logger.debug("function call: getCatalogSeparator() return is ':'");
        return ":";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        logger.debug("function call: getCatalogTerm()");
        return "project";
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        logger.debug("Function call getClientInfoProperties()");
        return new DMDResultSet((Object[])new Object[][]{{"iSQL", 64, "iSQL", "http://isql.sourceforge.net/"}}, new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"}, DMDResultSet.DMDResultSetType.getClientInfoProperties);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        logger.debug("Function call getColumnPrivileges(String,String,String,String)");
        logger.debug("Returning an empty resultset");
        String[] Col = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        return new DMDResultSet((Object[])new Object[][]{{null, null, table, "", null, "", "", "NO"}}, Col, DMDResultSet.DMDResultSetType.getColumnPrivileges);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        logger.debug("Function call getColumnscatalog: " + (catalog != null ? catalog : "null") + ", schemaPattern: " + (schemaPattern != null ? schemaPattern : "null") + ", tableNamePattern:" + (tableNamePattern != null ? tableNamePattern : "null") + ", columnNamePattern: " + (columnNamePattern != null ? columnNamePattern : "null"));
        List<Table> Tables2 = null;
        try {
            Tables2 = BQSupportFuncts.getTables(this.Connection, catalog, schemaPattern, tableNamePattern);
            if (Tables2 == null) {
                Tables2 = BQSupportFuncts.getTables(this.Connection, schemaPattern, catalog, tableNamePattern);
            }
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        if (Tables2 != null) {
            ArrayList<String[]> data = new ArrayList<String[]>();
            for (int i = 0; i < Tables2.size(); ++i) {
                String UparsedId = Tables2.get(i).getId();
                String ProjectId = BQSupportFuncts.getProjectIdFromAnyGetId(UparsedId).replace(":", "__").replace(".", "_");
                String DatasetId = BQSupportFuncts.getDatasetIdFromTableDotGetId(UparsedId);
                String TableId = BQSupportFuncts.getTableIdFromTableDotGetId(UparsedId);
                List<TableFieldSchema> tblfldschemas = Tables2.get(i).getSchema().getFields();
                if (tblfldschemas == null || tblfldschemas.size() == 0) continue;
                int index = 1;
                for (TableFieldSchema Column2 : tblfldschemas) {
                    if (columnNamePattern == null || BQSupportFuncts.matchPattern(Column2.getName(), columnNamePattern)) {
                        String[] Col = new String[]{ProjectId, DatasetId, TableId, Column2.getName(), String.valueOf(BQSupportFuncts.parseToSqlFieldType(Column2.getType())), Column2.getType(), "0", null, null, null, Column2.getMode(), null, "String", Column2.getType(), null, String.valueOf(65536), String.valueOf(index), "", null, null, null, null, ""};
                        data.add(Col);
                    }
                    ++index;
                }
            }
            if (data.size() == 0) {
                return null;
            }
            String[][] List2 = new String[data.size()][23];
            for (int i = 0; i < data.size(); ++i) {
                List2[i] = (String[])data.get(i);
            }
            return new DMDResultSet((Object[])List2, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT"}, DMDResultSet.DMDResultSetType.getColumns);
        }
        return new DMDResultSet((Object[])new String[][]{{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}}, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT"}, DMDResultSet.DMDResultSetType.getColumns);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.Connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        logger.debug("Function call getCrossReference(String,String,String,String,String,String)");
        String[] Col = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        return new DMDResultSet((Object[])new Object[0][14], Col, DMDResultSet.DMDResultSetType.getCrossReference);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Microsoft SQL Server";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "google bigquery v2-1.3.3-beta";
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return BQDriver.getMajorVersionAsStatic();
    }

    @Override
    public int getDriverMinorVersion() {
        return BQDriver.getMinorVersionAsStatic();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Starschema.net:BigQuery JDBC driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return BQDriver.getMajorVersionAsStatic() + "." + BQDriver.getMinorVersionAsStatic();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        logger.debug("Function call getExportedKeys(String,String,String)");
        String[] Col = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        return new DMDResultSet((Object[])new Object[0][14], Col, DMDResultSet.DMDResultSetType.getExportedKeys);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "( ) : . , \\ \" / ' ' * < = > + - % & | ^ << >> ~ != <> >= <= ";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        logger.debug("Function call getFunctionColumns(String,String,String,String)");
        throw new BQSQLException("Not implemented.getFunctionColumns(String,String,String,String)");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        logger.debug("Function call getFunctions(String,String,String)");
        throw new BQSQLException("Not implemented.getFunctions(String,String,String)");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\\\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        logger.debug("Function call getImportedKeys(String,String,String)");
        String[] Col = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM ", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        return new DMDResultSet((Object[])new Object[0][14], Col, DMDResultSet.DMDResultSetType.getImportedKeys);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        logger.debug("Function call getIndexInfo(String,String,String,boolean,boolean) returning an empty resultset");
        String[] Col = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        return new DMDResultSet((Object[])new Object[0][13], Col, DMDResultSet.DMDResultSetType.getIndexInfo);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return BQDriver.getMajorVersionAsStatic();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return BQDriver.getMinorVersionAsStatic();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 65536;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "{ fn  ABS() },{ fn  ACOS() },{ fn  ACOSH() },{ fn  ASIN() },{ fn  ASINH() },{ fn  ATAN() },{ fn  ATANH() },{ fn  ATAN2() },{ fn  CEIL() },{ fn  COS() },{ fn  COSH() },{ fn  COT() },{ fn  DEGREES() },{ fn  FLOOR() },{ fn  LN() },{ fn  LOG() },{ fn  LOG2() },{ fn  LOG10() },{ fn  PI() },{ fn  POW() },{ fn  RADIANS() },{ fn  ROUND() },{ fn  SIN() },{ fn  SINH() },{ fn  SQRT() },{ fn  TAN() },{ fn  TANH() }";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        logger.debug("Function call getPrimaryKeys(String,String,String)");
        String[] Col = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        return new DMDResultSet((Object[])new Object[0][8], Col, DMDResultSet.DMDResultSetType.getPrimaryKeys);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        logger.debug("Function call getProcedureColumns(String,String,String,String)");
        String[] Col = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"};
        return new DMDResultSet((Object[])new Object[0][20], Col, DMDResultSet.DMDResultSetType.getProcedureColumns);
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        logger.debug("Function call getProcedures(String,String,String)");
        String[] Col = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "", "", "", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"};
        return new DMDResultSet((Object[])new Object[0][9], Col, DMDResultSet.DMDResultSetType.getProcedures);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        List<ProjectList.Projects> Projects2;
        logger.debug("Function call getSchemas()");
        String[][] data = null;
        try {
            Projects2 = ((ProjectList)this.Connection.getBigquery().projects().list().execute()).getProjects();
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        if (Projects2 != null && Projects2.size() != 0) {
            for (ProjectList.Projects proj : Projects2) {
                DatasetList datasetcontainer = null;
                try {
                    datasetcontainer = (DatasetList)this.Connection.getBigquery().datasets().list(proj.getId()).execute();
                }
                catch (IOException e) {
                    throw new BQSQLException(e);
                }
                List<DatasetList.Datasets> datasetlist = datasetcontainer.getDatasets();
                if (datasetlist == null || datasetlist.size() == 0) continue;
                data = new String[datasetlist.size()][2];
                int i = 0;
                for (DatasetList.Datasets datasets : datasetlist) {
                    data[i][0] = datasets.getDatasetReference().getDatasetId();
                    data[i][1] = datasets.getDatasetReference().getProjectId().replace(".", "_").replace(":", "__");
                    ++i;
                }
            }
        }
        if (data != null) {
            logger.debug("data was not null, data length = " + data.length);
            for (int i = 0; i < data.length; ++i) {
                logger.debug("data" + i + "[0],[1] = " + data[i][0].toString() + "," + data[i][1].toString());
            }
            return new DMDResultSet((Object[])data, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, DMDResultSet.DMDResultSetType.getSchemas);
        }
        logger.debug("data was null");
        return new DMDResultSet((Object[])new String[][]{{null, null}}, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, DMDResultSet.DMDResultSetType.getSchemas);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        List<ProjectList.Projects> Projects2;
        logger.debug("Function call getSchemas(String,String)");
        String[][] data = null;
        String[] Col = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
        try {
            Projects2 = ((ProjectList)this.Connection.getBigquery().projects().list().execute()).getProjects();
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        if (Projects2 != null && Projects2.size() != 0) {
            for (ProjectList.Projects proj : Projects2) {
                DatasetList datasetcontainer = null;
                try {
                    datasetcontainer = (DatasetList)this.Connection.getBigquery().datasets().list(proj.getId()).execute();
                }
                catch (IOException e) {
                    throw new BQSQLException(e);
                }
                List<DatasetList.Datasets> datasetlist = datasetcontainer.getDatasets();
                if (datasetlist == null || datasetlist.size() == 0) continue;
                data = new String[datasetlist.size()][2];
                int i = 0;
                for (DatasetList.Datasets datasets : datasetlist) {
                    String schema = datasets.getDatasetReference().getDatasetId();
                    String projnm = datasets.getDatasetReference().getProjectId();
                    logger.debug("We search for catalog/project: " + catalog);
                    if (!schema.equals(schemaPattern) && schemaPattern != null || !projnm.equals(catalog) && catalog != null) continue;
                    data[i][0] = schema;
                    data[i][1] = projnm;
                    ++i;
                }
            }
        }
        if (data != null) {
            return new DMDResultSet((Object[])data, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, DMDResultSet.DMDResultSetType.getSchemas);
        }
        return new DMDResultSet((Object[])new String[][]{{null, null}}, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, DMDResultSet.DMDResultSetType.getSchemas);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "PI,POW,RADIANS,ROUND,SIN,SINH,SQRT,TAN,TANH,BOOLEAN,HEX_STRING,STRING,IFNULL,IS_INF,IS_NAN,IS_EXPLICITLY_DEFINED,FORMAT_IP,PARSE_IP,FORMAT_PACKED_IP,PARSE_PACKED_IP,REGEXP_MATCH,REGEXP_EXTRACT,REGEXP_REPLACE,CONCAT,LENGTH,LOWER,LPAD,RIGHT,RPAD,SUBSTR,UPPER,FORMAT_UTC_USEC,NOW,PARSE_UTC_USEC,STRFTIME_UTC_USEC,UTC_USEC_TO_DAY,UTC_USEC_TO_HOUR,UTC_USEC_TO_MONTH,UTC_USEC_TO_WEEK,UTC_USEC_TO_YEAR,POSITION";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "{ fn CONCAT() },{ fn LEFT() },{ fn LENGTH() },{ fn LOWER() },{ fn LPAD() },{ fn RIGHT() },{ fn RPAD() },{ fn SUBSTR() },{ fn UPPER( },";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        logger.debug("Function call getSuperTables(String,String,String)");
        String[] Col = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        return new DMDResultSet((Object[])new Object[0][4], Col, DMDResultSet.DMDResultSetType.getSuperTables);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        logger.debug("Function call getSuperTypes(String,String,String)");
        String[] Col = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        return new DMDResultSet((Object[])new Object[0][6], Col, DMDResultSet.DMDResultSetType.getSuperTypes);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        logger.debug("Function call getTablePrivileges(String,String,String)");
        String[] Col = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        return new DMDResultSet((Object[])new Object[0][8], Col, DMDResultSet.DMDResultSetType.getTablePrivileges);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (catalog != null && (catalog == " " || catalog.length() == 0)) {
            logger.debug("Catalog length was: " + catalog.length() + " it's an empty string replacing it with 'null' ");
            catalog = null;
        }
        if (schemaPattern != null && (schemaPattern == " " || schemaPattern.length() == 0)) {
            logger.debug("schemaPattern length was: " + schemaPattern.length() + " it's an empty string replacing it with 'null' ");
            schemaPattern = null;
        }
        String typesToLog = "";
        if (types != null) {
            for (String string : types) {
                typesToLog = typesToLog + string + " , ";
            }
        }
        logger.debug("Function call getTables(catalog: " + (catalog != null ? catalog : "null") + ", schemaPattern: " + (schemaPattern != null ? schemaPattern : "null") + ", tableNamePattern: " + (tableNamePattern != null ? tableNamePattern : "null") + ", types: " + typesToLog + ")");
        List<Table> tables = null;
        try {
            tables = BQSupportFuncts.getTables(this.Connection, catalog, schemaPattern, tableNamePattern);
            if (tables == null) {
                tables = BQSupportFuncts.getTables(this.Connection, tableNamePattern, schemaPattern, catalog);
            }
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        if (tables != null && tables.size() != 0) {
            logger.debug("got result, size: " + tables.size());
            String[][] data = new String[tables.size()][10];
            for (int i = 0; i < tables.size(); ++i) {
                String UparsedId = tables.get(i).getId();
                data[i][0] = BQSupportFuncts.getProjectIdFromAnyGetId(UparsedId).replace(":", "__").replace(".", "_");
                data[i][1] = BQSupportFuncts.getDatasetIdFromTableDotGetId(UparsedId);
                data[i][2] = BQSupportFuncts.getTableIdFromTableDotGetId(UparsedId);
                data[i][3] = "TABLE";
                data[i][4] = tables.get(i).getDescription();
                data[i][5] = null;
                data[i][6] = BQSupportFuncts.getProjectIdFromAnyGetId(UparsedId).replace(":", "__").replace(".", "_");
                data[i][7] = BQSupportFuncts.getDatasetIdFromTableDotGetId(UparsedId);
                data[i][8] = BQSupportFuncts.getTableIdFromTableDotGetId(UparsedId);
                data[i][9] = null;
            }
            return new DMDResultSet((Object[])data, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, DMDResultSet.DMDResultSetType.getTables);
        }
        logger.debug("no result or empty result, returning with nulls");
        return new DMDResultSet((Object[])new String[][]{{null, null, null, null, null, null, null, null, null, null}}, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, DMDResultSet.DMDResultSetType.getTables);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        logger.debug("Function call getTableTypes()");
        ArrayList<String> Res = new ArrayList<String>();
        Res.add("TABLE");
        return new DMDResultSet(Res.toArray(), new String[]{"TABLE_TYPE"}, DMDResultSet.DMDResultSetType.getTableTypes);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "{ fn FORMAT_UTC_USEC() },{ fn NOW() },{ fn PARSE_UTC_USEC() },{ fn STRFTIME_UTC_USEC() },{ fn UTC_USEC_TO_DAY() },{ fn UTC_USEC_TO_HOUR() },{ fn UTC_USEC_TO_MONTH() },{ fn UTC_USEC_TO_WEEK() },{ fn UTC_USEC_TO_YEAR() }";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        logger.debug("Function call getTypeInfo()");
        logger.debug("Not implemented, returning empty result");
        String[] Col = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        return new DMDResultSet((Object[])new Object[0][18], Col, DMDResultSet.DMDResultSetType.getTypeInfo);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        logger.debug("Function call getUDTs(String,String,String,int[])");
        logger.debug("not implemented, returning an empty resultset");
        String[] Col = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        return new DMDResultSet((Object[])new Object[0][7], Col, DMDResultSet.DMDResultSetType.getUDTs);
    }

    @Override
    public String getURL() throws SQLException {
        return "https://developers.google.com/bigquery/";
    }

    @Override
    public String getUserName() throws SQLException {
        logger.debug("Function call getUserName()  returning the projectID: " + this.Connection.getProjectId());
        return this.Connection.getProjectId();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        logger.debug("Function call getVersionColumns(String,String,String)");
        logger.debug("not implemented, returning an empty resultset");
        String[] Col = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        return new DMDResultSet((Object[])new Object[0][8], Col, DMDResultSet.DMDResultSetType.getVersionColumns);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        logger.debug("Function call isCatalogAtStart(), return is true ");
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return multipleOpenResultsSupported;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (1003 == type) {
            if (1007 == concurrency) {
                return true;
            }
            if (1008 == concurrency) {
                return false;
            }
        }
        if (1004 == type) {
            if (1007 == concurrency) {
                return true;
            }
            if (1008 == concurrency) {
                return false;
            }
        }
        if (1005 == type) {
            if (1007 == concurrency) {
                return true;
            }
            if (1008 == concurrency) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        if (type == 1004) {
            return true;
        }
        return type == 1003;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return 0 == level;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new BQSQLException("no object found that implements " + iface.toString());
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }
}

