% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbGetInfo,DatabaseConnectorConnection-method}
\alias{dbGetInfo,DatabaseConnectorConnection-method}
\title{Get DBMS metadata}
\usage{
\S4method{dbGetInfo}{DatabaseConnectorConnection}(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
For objects of class \linkS4class{DBIDriver}, \code{dbGetInfo()}
returns a named list
that contains at least the following components:
\itemize{
\item \code{driver.version}: the package version of the DBI backend,
\item \code{client.version}: the version of the DBMS client library.
}

For objects of class \linkS4class{DBIConnection}, \code{dbGetInfo()}
returns a named list
that contains at least the following components:
\itemize{
\item \code{db.version}: version of the database server,
\item \code{dbname}: database name,
\item \code{username}: username to connect to the database,
\item \code{host}: hostname of the database server,
\item \code{port}: port on the database server.
It must not contain a \code{password} component.
Components that are not applicable should be set to \code{NA}.
}

For objects of class \linkS4class{DBIResult}, \code{dbGetInfo()}
returns a named list
that contains at least the following components:
\itemize{
\item \code{statatment}: the statement used with \code{\link[DBI:dbSendQuery]{dbSendQuery()}} or \code{\link[DBI:dbExecute]{dbExecute()}},
as returned by \code{\link[DBI:dbGetStatement]{dbGetStatement()}},
\item \code{row.count}: the number of rows fetched so far (for queries),
as returned by \code{\link[DBI:dbGetRowCount]{dbGetRowCount()}},
\item \code{rows.affected}: the number of rows affected (for statements),
as returned by \code{\link[DBI:dbGetRowsAffected]{dbGetRowsAffected()}}
\item \code{has.completed}: a logical that indicates
if the query or statement has completed,
as returned by \code{\link[DBI:dbHasCompleted]{dbHasCompleted()}}.
}
}
\description{
Retrieves information on objects of class \linkS4class{DBIDriver},
\linkS4class{DBIConnection} or \linkS4class{DBIResult}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetInfo")}
}
\seealso{
Other DBIDriver generics: 
\code{\link[DBI]{DBIDriver-class}},
\code{\link[DBI]{dbCanConnect}()},
\code{\link[DBI]{dbConnect}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDriver}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListConnections}()}

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}

Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
