% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbExecute,DatabaseConnectorConnection,character-method}
\alias{dbExecute,DatabaseConnectorConnection,character-method}
\title{Execute an update statement, query number of rows affected, and then close result set}
\usage{
\S4method{dbExecute}{DatabaseConnectorConnection,character}(conn, statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExecute()} always returns a
scalar
numeric
that specifies the number of rows affected
by the statement.
An error is raised when issuing a statement over a closed
or invalid connection,
if the syntax of the statement is invalid,
or if the statement is not a non-\code{NA} string.
}
\description{
Executes a statement and returns the number of rows affected.
\code{dbExecute()} comes with a default implementation
(which should work with most backends) that calls
\code{\link[DBI:dbSendStatement]{dbSendStatement()}}, then \code{\link[DBI:dbGetRowsAffected]{dbGetRowsAffected()}}, ensuring that
the result is always free-d by \code{\link[DBI:dbClearResult]{dbClearResult()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbExecute")}
}
\details{
You can also use \code{dbExecute()} to call a stored procedure
that performs data manipulation or other actions that do not return a result set.
To execute a stored procedure that returns a result set use \code{\link[DBI:dbGetQuery]{dbGetQuery()}} instead.
}
\seealso{
For queries: \code{\link[DBI:dbSendQuery]{dbSendQuery()}} and \code{\link[DBI:dbGetQuery]{dbGetQuery()}}.

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
