% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbReadTable,DatabaseConnectorConnection,character-method}
\alias{dbReadTable,DatabaseConnectorConnection,character-method}
\title{Copy data frames from database tables}
\usage{
\S4method{dbReadTable}{DatabaseConnectorConnection,character}(
  conn,
  name,
  database = NULL,
  schema = NULL,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{database}{Name of the database.}

\item{schema}{Name of the schema.}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables. To
emulate temp tables, provide a schema with write privileges where temp tables
can be created.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbReadTable()} returns a data frame that contains the complete data
from the remote table, effectively the result of calling \code{\link[DBI:dbGetQuery]{dbGetQuery()}}
with \verb{SELECT * FROM <name>}.
An error is raised if the table does not exist.
An empty table is returned as a data frame with zero rows.

The presence of \link[DBI]{rownames} depends on the \code{row.names} argument,
see \code{\link[DBI:rownames]{sqlColumnToRownames()}} for details:
\itemize{
\item If \code{FALSE} or \code{NULL}, the returned data frame doesn't have row names.
\item If \code{TRUE}, a column named "row_names" is converted to row names,
an error is raised if no such column exists.
\item If \code{NA}, a column named "row_names" is converted to row names if it exists,
otherwise no translation occurs.
\item If a string, this specifies the name of the column in the remote table
that contains the row names,
an error is raised if no such column exists.
}

The default is \code{row.names = FALSE}.

If the database supports identifiers with special characters,
the columns in the returned data frame are converted to valid R
identifiers
if the \code{check.names} argument is \code{TRUE},
If \code{check.names = FALSE}, the returned table has non-syntactic column names without quotes.

An error is raised when calling this method for a closed
or invalid connection.
An error is raised
if \code{name} cannot be processed with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Unsupported values for \code{row.names} and \code{check.names}
(non-scalars,
unsupported data types,
\code{NA} for \code{check.names})
also raise an error.
}
\description{
Reads a database table to a data frame, optionally converting
a column to row names and converting the column names to valid
R identifiers.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbReadTable")}
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
