% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbReadTable,DatabaseConnectorConnection,character-method}
\alias{dbReadTable,DatabaseConnectorConnection,character-method}
\title{Copy data frames from database tables}
\usage{
\S4method{dbReadTable}{DatabaseConnectorConnection,character}(conn, name,
  database = NULL, schema = NULL, oracleTempSchema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{database}{Name of the database.}

\item{schema}{Name of the schema.}

\item{oracleTempSchema}{Specifically for Oracle, a schema with write priviliges where temp tables
can be created.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbReadTable()} returns a data frame that contains the complete data
from the remote table, effectively the result of calling \code{\link[=dbGetQuery]{dbGetQuery()}}
with \code{SELECT * FROM <name>}.
An error is raised if the table does not exist.
An empty table is returned as a data frame with zero rows.

The presence of \link{rownames} depends on the \code{row.names} argument,
see \code{\link[=sqlColumnToRownames]{sqlColumnToRownames()}} for details:
\itemize{
\item If \code{FALSE} or \code{NULL}, the returned data frame doesn't have row names.
\item If \code{TRUE}, a column named "row_names" is converted to row names,
an error is raised if no such column exists.
\item If \code{NA}, a column named "row_names" is converted to row names if it exists,
otherwise no translation occurs.
\item If a string, this specifies the name of the column in the remote table
that contains the row names,
an error is raised if no such column exists.
}

The default is \code{row.names = FALSE}.

If the database supports identifiers with special characters,
the columns in the returned data frame are converted to valid R
identifiers
if the \code{check.names} argument is \code{TRUE},
otherwise non-syntactic column names can be returned unquoted.

An error is raised when calling this method for a closed
or invalid connection.
An error is raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Unsupported values for \code{row.names} and \code{check.names}
(non-scalars,
unsupported data types,
\code{NA} for \code{check.names})
also raise an error.
}
\description{
Reads a database table to a data frame, optionally converting
a column to row names and converting the column names to valid
R identifiers.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbReadTable")}
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
