% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateETrefPM.R
\name{calculateETrefPM}
\alias{calculateETrefPM}
\title{The FAO Penman–Monteith for calculating daily reference evapotranspiration}
\usage{
calculateETrefPM(
  data = NULL,
  Lat = NULL,
  Alt = NULL,
  Alt_an = NULL,
  DAP = 1,
  Date = NULL,
  Temp = NULL,
  G = NULL,
  Humid = NULL,
  Rad = NULL,
  Press = NULL,
  Wind = NULL,
  Kc = NULL
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{Lat}{Numeric, latitude in decimals}

\item{Alt}{Numeric, altitude in meters}

\item{Alt_an}{Numeric, anemometer height in meters}

\item{DAP}{Numeric, days after planting for the first column date}

\item{Date}{String with the column name containing date records (R default date: "\%Y-\%m-\%d")}

\item{Temp}{String with the column name containing temperature records in °C}

\item{G}{Optional, if NULL will be considered as zero. String with the column name containing soil heat flux (MJ/m²/day)}

\item{Humid}{String with the column name containing relative humidity records in \%}

\item{Rad}{String with the column name containing global radiation records in MJ/m²}

\item{Press}{String with the column name containing atmospheric pressure records in hPa}

\item{Wind}{String with the column name containing wind speed records in m/s}

\item{Kc}{Optional, when not NULL the crop evapotranspiration ETc is calculated based on ETref. String with the column name containing crop coefficient (Kc) records}
}
\value{
Data frame with:
Date;
ETref - reference evapotranspiration (mm/dia);
LLI - irrigation level (mm/dia);
DJ - julian day;
DAP - days after planting;
es - saturation vapor pressure (kPa);
ea - actual vapor pressure (kPa);
delta - slope of the saturated water–vapor-pressure curve (kPA/°C);
y - psychrometric constant (kPA/°C);
Rn - net radiation (MJ/m²/dia);
ETc - crop evapotranspiration (mm/dia) (depends on supply of Kc)
}
\description{
Calculation of daily reference evapotranspiration using the PM method for a dataset stored in a data.frame (Allen et al., 1998).
}
\details{
The FAO Penman–Monteith method:

\deqn{ETrefPM = \frac{0.408 \Delta(Rn-G) + \gamma \frac{900}{T+273}u_{2}(e_{s}-e_{a})}{\Delta+\gamma(1+0.34u_{2})}}

where: ETref - reference evapotranspiration (mm/dia), delta - slope of the saturated water–vapor-pressure curve (kPA/°C), Rn - net radiation (MJ/m²/dia), G - soil heat flux (MJ/m²/day), y - psychrometric constant (kPA/°C), T - average daily air temperature (°C), u2 -wind speed at 2m height (m/s), es - saturation vapor pressure (kPa), e ea - actual vapor pressure (kPa)
}
\examples{
address <-
 base::system.file("extdata",
                    "ex2_daily.CSV",
                    package = "DataMetProcess")

df <- read.table(
address,
h = TRUE,
sep = ";"
)

#converting to Mj/m
df$radiacao_global_kj_m <- df$radiacao_global_kj_m/1000
colnames(df)[3] <- "radiacao_global_mj_m"

df.Eto <-
  calculateETrefPM(
    data = df,
    Lat = -21.980353,
    Alt = 859.29,
    Alt_an = 10,
    DAP = 1,
    Date = colnames(df)[1],
    Temp = colnames(df)[7],
    G = NULL,
    Humid = colnames(df)[15],
    Rad = colnames(df)[3],
    Press = colnames(df)[4],
    Wind = colnames(df)[18],
    Kc = NULL
  )


}
\references{
Allen, R.G., Pereira, L.S., Raes, D., Smith, M., 1998. Crop evapotranspiration – guidelines for computing crop water requirements – FAO Irrigation and Drainage Paper 56. FAO, 1998. ISBN 92-5-104219-5.
}
