% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_histogram.r
\name{plot_histogram}
\alias{plot_histogram}
\title{Plot histogram}
\usage{
plot_histogram(data, binary_as_factor = TRUE,
  geom_histogram_args = list(bins = 30L), title = NULL,
  ggtheme = theme_gray(), theme_config = list(), nrow = 4L,
  ncol = 4L, parallel = FALSE)
}
\arguments{
\item{data}{input data}

\item{binary_as_factor}{treat binary as categorical? Default is \code{TRUE}.}

\item{geom_histogram_args}{a list of other arguments to \link{geom_histogram}}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page. Default is 4.}

\item{ncol}{number of columns per page. Default is 4.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot histogram for each continuous feature
}
\examples{
# Plot iris data
plot_histogram(iris, nrow = 2L, ncol = 2L)

# Plot random data
set.seed(1)
data <- data.frame(replicate(16L, rnorm(50)))
plot_histogram(data)
}
\seealso{
\link{geom_histogram} \link{plot_density}
}
\keyword{plot_histogram}
