% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DensityContinuous.r
\name{DensityContinuous}
\alias{DensityContinuous}
\title{Visualize density estimates for continuous features}
\usage{
DensityContinuous(data, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{\dots}{other arguments to be passed to \link{geom_density}.}
}
\description{
This function visualizes density estimates for each continuous feature.
}
\examples{
# load library
library(data.table)

# plot using iris data
DensityContinuous(iris)

# plot using random data
set.seed(1)
data <- cbind(sapply(1:9, function(x) {
          runif(500, min = sample(100, 1), max = sample(1000, 1))
        }))
DensityContinuous(data)
}
\keyword{densitycontinuous}

