% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataEdit.R
\name{dataEdit}
\alias{dataEdit}
\alias{dataEditUI}
\alias{dataEditServer}
\title{Shiny module for data editing}
\usage{
dataEditUI(id)

dataEditServer(
  id,
  data = reactive(NULL),
  col_bind = NULL,
  col_edit = TRUE,
  col_options = NULL,
  col_stretch = FALSE,
  col_names = TRUE,
  col_readonly = NULL,
  col_factor = FALSE,
  row_bind = NULL,
  row_edit = TRUE,
  quiet = FALSE,
  read_fun = "read.csv",
  read_args = NULL,
  ...
)
}
\arguments{
\item{id}{unique identifier for the module to prevent namespace clashes when
making multiple calls to this shiny module.}

\item{data}{a reactive expression containing an array (e.g. data.frame,
matrix or data.table) or a vector indicating the dimensions of the array
(e.g. c(10,10)) or column names to construct a new template for editing. If
no data is supplied a template with 10 rows and columns will be generated
for editing.}

\item{col_bind}{additional columns to add to the data prior to loading into
editor, can be either an array containing the new data, a vector containing
the new column names for empty columns or a named list containing a vector
for each new column.}

\item{col_edit}{logical indicating whether columns can be added or removed,
set to TRUE by default.}

\item{col_options}{a list named with valid columns names and either
\code{c(TRUE, FALSE)} for checkboxes, a vector of options for dropdowns,
\code{"date"} for date input or \code{"password"} for password input.}

\item{col_stretch}{logical indicating whether columns should be stretched to
fill the full width of the display, set to FALSE by default.}

\item{col_names}{logical indicating whether column names can be edited or a
vector of column names that cannot be edited, set to TRUE by default to
allow editing of column names.}

\item{col_readonly}{names of columns that cannot be edited. Users will be
able to edit values but these will be reverted to the original values.
Column names for these column cannot be edited either.}

\item{col_factor}{logical indicating whether character columns should be
converted to factors prior to returning the edited data, set to FALSE by
default.}

\item{row_bind}{additional rows to add to the data prior to loading into
editor, can be either an array containing the new data, a vector containing
the new row names for empty rows or a named list containing a vector for
each new column.}

\item{row_edit}{logical indicating whether rows can be added or removed, set
to TRUE by default.}

\item{quiet}{logical to suppress warnings when using \code{col_options}.}

\item{read_fun}{name of the function to use to read in the data when a file
is selected, set to \code{read.csv} by default.}

\item{read_args}{a named list of additional arguments to pass to
\code{read_fun} when reading in files.}

\item{...}{additional arguments passed to
\code{\link[rhandsontable:rhandsontable]{rhandsontable}}.}
}
\description{
Shiny module for data editing
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    dataInputUI("input-1"),
    dataOutputUI("output-1"),
    dataEditUI("edit-1")
  )

  server <- function(input, output, session) {
    data_to_edit <- dataInputServer("input-1")
    data_to_edit <- dataEditServer("edit-1",
      data = data_to_edit
    )
    dataOutputServer("output-1",
      data = data_to_edit
    )
  }

  shinyApp(ui, server)
}
}
\author{
Dillon Hammill, \email{Dillon.Hammill@anu.edu.au}
}
