% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_2AFBDTW.R
\name{dist_afbdtw}
\alias{dist_afbdtw}
\title{Adaptive Feature Based Dynamic Time Warping algorithm}
\usage{
dist_afbdtw(q, r, w1 = 0.5)
}
\arguments{
\item{q}{query vector}

\item{r}{reference vector}

\item{w1}{weight of local feature VS global feature.
By default, w1 = 0.5, and by definition, w2 = 1 - w1.}
}
\value{
A list containing the following elements:
\itemize{
\item{query: }{the query vector}
\item{response: }{the response vector}
\item{query_local: }{local feature of the query}
\item{response_local: }{local feature of the response vector}
\item{query_global: }{global feature of the query}
\item{response_global: }{global feature of the response vector}
\item{dist_local: }{distance matrix of the local feature}
\item{dist_local: }{distance matrix of the global feature}
\item{distAFBDTW: }{AFBDTW distance matrix}
}
}
\description{
This function estimates a distance matrix which is used as an input in dtw() function (package dtw) to align two univariate signals following Adaptative Feature Based Dynamic Time Warping algorithm (AFBDTW).
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
AFBDTW_Dist <- dist_afbdtw(X, Y)
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
