% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{rowbind.DTSg}
\alias{rowbind.DTSg}
\alias{rowbind}
\alias{rbind}
\title{Combine rows}
\usage{
\method{rowbind}{DTSg}(x, ..., clone = getOption("DTSgClone"))
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{\dots}{Any number of \code{\link{DTSg}} objects or objects coercible to one (see
\code{\link{new}} for further information). \code{\link{list}}s of such objects or a mixture of
lists and non-lists are also accepted.}

\item{clone}{A logical specifying if the object shall be modified in place or
if a deep clone (copy) shall be made beforehand.}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Combines the rows of \code{\link{DTSg}} and other suitable objects.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow[1:500, ])

# combine rows
## R6 method
x$rowbind(
  list(flow[1001:1500, ], DTSg$new(values = flow[501:1000, ])),
  flow[1501:.N, ]
)$print()

## 'rbind()' is a "hidden" R6 alias for 'rowbind()'
x$rbind(
  list(flow[1001:1500, ], DTSg$new(values = flow[501:1000, ])),
  flow[1501:.N, ]
)$print()

## S3 method
print(rowbind(
  x = x,
  list(flow[1001:1500, ], DTSg$new(values = flow[501:1000, ])),
  flow[1501:.N, ]
))

}
\seealso{
\code{\link{cols}}, \code{\link{getOption}}
}
