% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{alter.DTSg}
\alias{alter.DTSg}
\alias{alter}
\title{Alter Time Series}
\usage{
\method{alter}{DTSg}(
  x,
  from = first(self$values(reference = TRUE)[[".dateTime"]]),
  to = last(self$values(reference = TRUE)[[".dateTime"]]),
  by = self$periodicity,
  rollback = TRUE,
  clone = getOption("DTSgClone"),
  na.status = self$na.status,
  ...
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{from}{A \code{\link{POSIXct}} date with the same time zone as the time
series or a character string coercible to one. Specifies the new start of
the time series.}

\item{to}{A \code{\link{POSIXct}} date with the same time zone as the time
series or a character string coercible to one. Specifies the new end of the
time series.}

\item{by}{Specifies the new periodicity in one of the ways the \code{by}
argument of \code{\link{seq.POSIXt}} can be specified. Must be specified for
time series with unrecognised periodicity. Time steps out of sync with the
new periodicity are dropped.}

\item{rollback}{A logical specifying if a call to \code{\link{rollback}} is
made when appropriate.}

\item{clone}{A logical specifying if the object is modified in place or if a
clone (copy) is made beforehand.}

\item{na.status}{A character string. Either \code{"explicit"}, which makes
missing timestamps according to the recognised periodicity explicit, or
\code{"implicit"}, which removes timestamps with missing values on all value
columns. Please note that \code{\link{DTSg}} objects work best with explicit
missing values.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Shortens, lengthens, changes the periodicity and/or the status of missing
 values of a \code{\link{DTSg}} object.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# subset the first two years
## R6 method
x$alter(from = "2007-01-01", to = "2008-12-31")

## S3 method
alter(x = x, from = "2007-01-01", to = "2008-12-31")

}
\seealso{
\code{\link{DTSg}}, \code{\link{values}}, \code{\link{POSIXct}},
 \code{\link{seq.POSIXt}}, \code{\link{rollback}}
}
