% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVDImpute.R
\name{SVDImpute}
\alias{SVDImpute}
\title{Improved SVD Imputation}
\usage{
SVDImpute(x, k, num.iters = 10, verbose = TRUE)
}
\arguments{
\item{x}{A data frame or matrix where each row represents a different record.}

\item{k}{The rank-k approximation to use for the data matrix.}

\item{num.iters}{The number of times to compute the rank-k approximation and impute the missing data.}

\item{verbose}{If TRUE, print status updates during the process.}
}
\value{
A list containing:
\item{data.matrix}{The imputed matrix with missing values filled.}
}
\description{
This function performs imputation using Singular Value Decomposition (SVD) with iterative refinement.
It begins by filling missing values with the mean of their respective columns.
Then, it computes a low-rank (k) approximation of the data matrix. Using this approximation,
it refills the missing values. This process of recomputing the rank-k approximation with
the newly imputed values and refilling the missing data is repeated for a specified number
of iterations, `num.iters`.
}
\examples{
# Create a sample matrix with random values and introduce missing values
x = matrix(rnorm(100), 10, 10)
x[x > 1] = NA

# Perform SVD imputation
imputed_x = SVDImpute(x, 3)

# Print the imputed matrix
print(imputed_x)
}
