% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class.Constructors.R
\name{make.region}
\alias{make.region}
\title{Creates a Region object}
\usage{
make.region(region.name = "region", strata.name = character(0),
  units = "m", area = numeric(0), shapefile = NULL, coords = coords <-
  list(list(data.frame(x = c(0, 0, 2000, 2000, 0), y = c(0, 500, 500, 0, 0)))),
  gaps = list(), check.LinkID = TRUE)
}
\arguments{
\item{region.name}{the region name}

\item{strata.name}{the strata names. If not supplied when there are 2 or mode strata default names of "A", "B", "C"... will be assigned.}

\item{units}{the units given as a character (either 'm' or 'km')}

\item{area}{the area of the region (optional - if not supplied it will be 
calculated for you using \code{areapl} from the splancs library)}

\item{shapefile}{a shapefile of the study region. These can be loaded using the \code{read.shapefile} function in the shapefiles library.}

\item{coords}{A list with one element per strata. Each element in the list is a list of dataframes describing the polygon coordinates. This allows multiple regions in each strata. The corrdinates should start and finish with the same point. By default DSsim will create a rectangular study region 2000 m by 500 m.}

\item{gaps}{A list with one element per strata. Each element in the list is a list of dataframes describing the polygon coordinates. This allows multiple gaps in each strata. The corrdinates should start and finish with the same point.}

\item{check.LinkID}{boolean to check the order of the LinkID value in the attribute table. This is important if this shapefile was used in Distance to create the survey shapefiles as Distance would have re-ordered the strata in this way. Failing to re-order the strata will mean that the strata in DSsim will not match the transect strata ID values created by Distance. If you have created your surveys outside Distance you can turn this option off.}
}
\value{
object of class Region
}
\description{
This creates an instance of the Region class. If the user supplied a 
shapefile all information will be extracted from here. Otherwise the user
needs to specify a list of polygons describing the areas of interest 
(coords) and optionally a list of polygons describing the areas to 
be excluded (gaps). If area is not specified it will be calculated.
}
\examples{
# A basic study region of 2000m by 500m is created using the defaults
region <- make.region()
plot(region)

# Here is an example of a 1000 x 1000 study region with a gap
coords <- gaps <- list()
coords[[1]] <- list(data.frame(x = c(0,1000,1000,0,0), y = c(0,0,
 1000,1000,0)))
gaps[[1]] <- list(data.frame(x = c(400,600,500,350,400), y = c(100,
 250,600,120,100)))

region <- make.region(region.name = "study.area", units = "m", 
 coords = coords, gaps = gaps)
plot(region)

}
\author{
Laura Marshall
}

