% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_tier.R
\name{write_tier}
\alias{write_tier}
\title{Writes data from a single DSSAT data tier}
\usage{
write_tier(
  tier_data,
  pad_name = NULL,
  drop_duplicate_rows = FALSE,
  drop_na_rows = TRUE
)
}
\arguments{
\item{tier_data}{a tibble containing the data to write out}

\item{pad_name}{a character vector of column names for which to add leading spaces/trailing periods}

\item{drop_duplicate_rows}{a logical value indicating whether duplicate rows
should be dropped from tier_data}

\item{drop_na_rows}{a logical value indicating whether rows containing all NA values
should be dropped from tier_data}
}
\value{
a character vector
}
\description{
Writes data from a single DSSAT data tier
}
\examples{

tier_data <- data.frame(TRNO=1:4,HWAM=rnorm(4,2000,250))

tier_data <- add_v_fmt(tier_data,v_fmt=c(TRNO='\%6.0f', HWAM='\%6.0f'))

output <- write_tier(tier_data)

}
