% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_filea.R
\name{read_filea}
\alias{read_filea}
\title{Reads data from a single DSSAT file A}
\usage{
read_filea(file_name, col_types = NULL, col_names = NULL, na_strings = NULL)
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}

\item{col_types}{One of NULL, a cols() specification, or a string.
See \code{\link[readr]{read_fwf}} or \code{vignette("readr")} for
more details.}

\item{col_names}{A character vector of column names; primarily
helpful for cases where there are no white spaces between column
names within the header line}

\item{na_strings}{a character vector of string to represent missing values}
}
\value{
a tibble containing the data from the raw DSSAT file
}
\description{
Reads data from a single DSSAT file A
}
\examples{

# Extract FileA path for sample file
sample_filea <- system.file('extdata','SAMPLE.CRA',package='DSSAT')

filea <- read_filea(sample_filea)

}
