% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArmadilloOAuth.R
\name{armadillo.get_credentials}
\alias{armadillo.get_credentials}
\title{Get credentials information}
\usage{
armadillo.get_credentials(server)
}
\arguments{
\item{server}{the URL of the Armadillo server}
}
\value{
The credentials
}
\description{
Get credentials information
}
\details{
This function fetched various details from the auth server, including refresh, id and
access tokens. NOTE: in order to get refresh token, refresh tokens should be turned on for this
armadillo instance on the auth server. When access tokens are fetched using this method, it
enables the automatic refreshing of tokens when they time out. This works by checking whether the
current token(s) have expired, and if so attempting to refresh them and write the refreshed
token to the connection and credentials objects in the global environment. For this to work
correctly, ensure that there only exists one DataSHIELD connections object in the global
environment, and that for each datasource there is only object containing their credentials.
}
\examples{
\dontrun{
example_url <- "https://armadillo.example.org"
credentials <- armadillo.get_credentials(example_url)

builder <- newDSLoginBuilder()
builder$append(
  url = example_url,
  server = "example_server",
  token = credentials@access_token,
  driver = "ArmadilloDriver")
logindata <- builder$build()

conns <- datashield.login(logins = logindata, assign = FALSE)
}
}
