% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalCentralityScore.R
\name{CalCentralityScore}
\alias{CalCentralityScore}
\title{Calculating eigenvector centrality of subpathways}
\usage{
CalCentralityScore(ExpData,Label,nperm=1000)
}
\arguments{
\item{ExpData}{A gene expression profile of interest (rows are genes, columns are samples).}

\item{Label}{A character vector consist of "0" and "1" which represent sample class in gene expression profile. "0" means normal sample and "1" means disease sample.}

\item{nperm}{Number of random permutations (default: 1000).}
}
\value{
A dataframe with seven columns those are subpathway ID, subpathway name, subpathway size, genes in subpathway, centralscore (eigenvector centrality), Pvalue and FDR.
}
\description{
The function "CalCentralityScore" is used to calculate the eigenvector centrality of subpathways.
}
\examples{
library(igraph)
#Obtain input data
GEP<-GetExample('GEP')
Slabel<-GetExample('Slabel')
#Run the function
\donttest{CentralityScoreResult<-CalCentralityScore(ExpData=GEP,Label=Slabel,nperm=1000)}
}
