% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{sim_data_exp}
\alias{sim_data_exp}
\title{Simulate experiment-like data with \emph{independent} binary Xs.}
\usage{
sim_data_exp(
  n,
  r.xy,
  approx = TRUE,
  tol = 0.01,
  max.iter = 30,
  verbose = FALSE,
  seed = NULL
)
}
\arguments{
\item{n}{Number of observations (cases).}

\item{r.xy}{A vector of expected correlations of each X (binary independent variable: 0 or 1) with Y.}

\item{approx}{Make the sample correlation matrix approximate more to values as specified in \code{r.xy}, using the method of orthogonal decomposition of residuals (i.e., making residuals more independent of Xs). Defaults to \code{TRUE}.}

\item{tol}{Tolerance of absolute difference between specified and empirical correlations. Defaults to \code{0.01}.}

\item{max.iter}{Maximum iterations for approximation. More iterations produce more approximate correlations, but the absolute differences will be convergent after about 30 iterations. Defaults to \code{30}.}

\item{verbose}{Print information about iterations that satisfy tolerance. Defaults to \code{FALSE}.}

\item{seed}{Random seed for replicable results. Defaults to \code{NULL}.}
}
\value{
Return a data.frame of simulated data.
}
\description{
Simulate experiment-like data with \emph{independent} binary Xs.
}
\examples{
\donttest{data = sim_data_exp(n=1000, r.xy=c(0.5, 0.3), seed=1)
cor(data)  # tol = 0.01

data = sim_data_exp(n=1000, r.xy=c(0.5, 0.3), seed=1,
                    verbose=TRUE)
cor(data)  # print iteration information

data = sim_data_exp(n=1000, r.xy=c(0.5, 0.3), seed=1,
                    verbose=TRUE, tol=0.001)
cor(data)  # more approximate, though not exact

data = sim_data_exp(n=1000, r.xy=c(0.5, 0.3), seed=1,
                    approx=FALSE)
cor(data)  # far less exact
}
}
\seealso{
\code{\link[=sim_data]{sim_data()}}
}
