% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/homozygous.R
\name{homozygous}
\alias{heterozygous}
\alias{homozygous}
\title{For which markers is the profile homozygous/heterozygous?}
\usage{
homozygous(x, markers = get.markers(x))
}
\arguments{
\item{x}{An integer matrix specifying either a single profile or a number of profiles.}

\item{markers}{Character vector stating the markers to check. Defaults to all markers of \code{x}.}
}
\value{
logical matrix The value at column \code{m} in row \code{i} denotes whether profile \code{i} is homozygous/heterozygous for marker \code{m}.
}
\description{
For which markers is the profile homozygous/heterozygous?
}
\examples{
x <- t(c(1L,1L,1L,2L))
colnames(x) <- c("locus1.1","locus1.2","locus2.1","locus2.2")

homozygous(x,markers = "locus1") # TRUE
homozygous(x,markers = "locus2") # FALSE
homozygous(x) # t(c(TRUE,FALSE))
y <- t(c(1L,NA,1L,2L))
colnames(y) <- c("locus1.1","locus1.2","locus2.1","locus2.2")
homozygous(y,markers = "locus1") # NA
homozygous(y,markers = "locus2") # FALSE
homozygous(y)   # t(c(NA,FALSE))
heterozygous(y) # t(c(NA,TRUE))
}

