\name{DMRMark}
\alias{DMRMark}

\title{
	Gibbs Sampler to estimate model parameters
}
\description{
	Given the M-values and probe distance, 
	this function calls Gibbs Sampler for estimating the parameters of
	non-homogeneous hidden Markov model.
}
\usage{
DMRMark(mv, L = rep(1, nrow(mv)), starting = NULL, 
		pd = NULL, initHeuristic = TRUE, 
		GSoptions = NULL)
}

\arguments{
  \item{mv}{The input M-values matrix, NA is not allowed.
}
  \item{L}{A vector to specify the distance between each probes in bp. 
  $L < 0$ represents
  change of chromosome. Default is $L = 1$ for all probes.
}
  \item{starting}{A vector to specify the position 
  to initial new chains. We suggest new chains
  should be initiated at least at starting of new chromosome.
  When it is null, new chains initiate at beginning and where $L > 100000
  or $L < 0$. 
}
  \item{pd}{A design matrix, which can be generated by 'stats::model.matrix'.
  If the M-values are totally paired or single paired, just leave it to be NULL.
}
  \item{initHeuristic}{If set to TRUE, heuristics will 
  be used for faster computation, which rely on
  finding good initial value and then using less iterations.
  . This will mask GS controls parameters of 'GSoptions'. 
  Recommended for getting some quick insight about new study.
  Default it TRUE.
}
  \item{GSoptions}{List of prior parameters and 
  GS control parameters. See \code{\link{MakeGSoptions}}. 
}
}

\details{
	This function is the main functionality of this package. 
	It takes the M-values and probe distance and calls 
	Gibbs Sampler for estimating the parameters of
	non-homogeneous hidden Markov model.
	New chains will be initiated at positions specified in 'starting'.
	Depends on the scale of M-values, this function may take certain time
	to the GS. In this situation user may first set 'initHeuristic = TRUE'
	for a quick insight.
}

\value{
	The return value depends on 'GSoptions$track'. In default situation
	('GSoptions$track = FALSE'), the return value is a list contains:
	\item{theta}{A vector contains posterior means of non-DMC's control groups.
}
	\item{mu}{A 2-by-2 matrix, each row 
	corresponding to the paired posterior mean of DMCs.
}
	\item{sigma12}{A vector contains posterior means 
	of variance of non-DMC's control groups.
}
	\item{sigmaN}{Single value, the posterior mean of variance of non-DMC's 
	between-group difference.
}
	\item{Sigma34}{An Array contains posterior means of DMC's Covariance.
}
	\item{charL}{Posterior means of characteristic length.
}
	\item{init}{The probabilities of the initial states of all chains.
	Sum up to 1.
	
	If 'GSoptions$track = TRUE', an additional dimension will be added to each 
	item of the list, and along this dimension user can retrieve the sample from
	each iterations.
}

}

\author{
	Linghao SHEN <sl013@ie.cuhk.edu.hk>
}

\seealso{
	See \code{\link{MakeGSoptions}} for different prior parameters 
	and Gibbs Sampler control parameters. See \code{\link{DMRViterbi}}
	for interpreting the estimated parameters.
}
\examples{

	# DMRMark
	# DMR detection performed on chr18 of a small BLCA dataset from TCGA
	data(BLCA)
	
	# Use a small subset
	nprobe <- 500 
	# M-values
	mv <- BLCA$mv[1:nprobe,]
	
	# Distance between probes, L<0 indicates acorssing chromosomes 
	L = BLCA$distance[1:nprobe]
	
	# Initialize new chain when probe distance too long 
	# or across different chromosomes
	newChains <- which((L > 100000) | L < 0)
	# The starting positions of new chains
	starting <- c(1, newChains[-length(newChains)]+1)
	
	# Run DMRMark with default options
	pars <- DMRMark(mv, L, starting)
	pars
}

