% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Input.R
\name{LBSPR}
\alias{LBSPR}
\title{Length-Based SPR Effort Control}
\usage{
LBSPR(x, Data, reps = NA, plot = FALSE, n = 5, smoother = TRUE,
  frac = 0.1)
}
\arguments{
\item{x}{A position in a data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{n}{Last number of years to run the model on.}

\item{smoother}{Logical. Should the SPR estimates be smoothed?}

\item{frac}{The fractional adjustment in effort if SPR is outside of target range}
}
\value{
An object of class \code{\link[=Rec-class]{Rec}} with the TAE slot(s) populated
}
\description{
The spawning potential ratio (SPR) is estimated using the LBSPR method
and compared to a target of 0.4.
}
\details{
Effort is increased by 10 per cent if the ratio of \eqn{\frac{\textrm{SPR}}{\textrm{SPR}_{\textrm{targ}}}} is
\eqn{\geq 1.25}, reduced by 10 per cent if the ratio is < 0.75, and remains unchanged
otherwise.

The effort HCR has not been tuned. The increase/decrease in effort can
be adjusted using the \code{frac} argument.#'
}
\section{Required Data}{

See \linkS4class{Data} for information on the \code{Data} object \cr


\code{LBSPR}: CAL, CAL_bins, L50, L95, LHYear, Mort, Year, vbK, vbLinf, wlb
}

\section{Rendered Equations}{
 
See \href{https://dlmtool.github.io/DLMtool/reference/LBSPR.html}{Online Documentation} for correctly rendered equations
}

\examples{
LBSPR(1, Data=DLMtool::SimulatedData, plot=TRUE)
}
\references{
Hordyk, A., Ono, K., Valencia, S., loneragan, N., and Prince J;
A novel length-based empirical estimation method of spawning potential ratio (SPR),
and tests of its performance, for small-scale, data-poor fisheries,
ICES Journal of Marine Science, 72 (1) 2015, 217-231,
}
