% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{get_equi_comms}
\alias{get_equi_comms}
\title{Get all equi-proportional communities at specific levels of richness}
\usage{
get_equi_comms(
  nvars,
  richness_lvl = 1:nvars,
  variables = paste0("Var", 1:nvars),
  threshold = 1e+06
)
}
\arguments{
\item{nvars}{Number of variables in the design}

\item{richness_lvl}{The richness levels (number of non-zero compositional variables
in a community) at which to return the equi-proportional communities.
Defaults to each richness level from 1 up to `nvars` (both inclusive).}

\item{variables}{Names for the variables. Will be used as column names for the
final result. Default is "Var" followed by column number.}

\item{threshold}{The maximum number of communities to select for each level
of richness for situations when there are too many
equi-proportional communities. Default value is a million. \cr
Note: if threshold < `number of possible equi-proportional communities`
at a given level of richness, a random selection of communities
equal to the number specified in threshold would be returned.}
}
\value{
A dataframe consisting all or a random selection of equi-proportional
        communities at each level of richness
}
\description{
Get all equi-proportional communities at specific levels of richness
}
\examples{
## Get all equi-proportional communities for each level of richness upto 10
data10 <- get_equi_comms(10)
head(data10, 12)

## Change variable names
data4 <- get_equi_comms(4, variables = c("Lollium perenne", "Chichorum intybus",
                                         "Trifolium repens", "Trifolium pratense"))
head(data4)

## Get equi-proportional communities at specific levels of richness
## Get all equi-proportional communities of four variables at richness
## levels 1 and 3
data4_13 <- get_equi_comms(nvars = 4, richness = c(1, 3))
data4_13

## If threshold is specified and it is less than the number of possible
## equi-proportional communites at a given level of richness, then a
## random selection of communities from the total possible would be returned
## Return only 2 random equi-proportional communities at the chosen richness
## levels
data4_13_2 <- get_equi_comms(nvars = 4, richness = c(1, 3), threshold = 2)
data4_13_2

## Set threshold to a very high positive number to ensure
## random selection is never performed
data_no_random <- get_equi_comms(nvars = 15,
                                 threshold = .Machine$integer.max)
head(data_no_random)
}
