% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equals2.R
\name{equals2}
\alias{equals2}
\title{Compare two elements and return true if both elements are the same.}
\usage{
equals2(v1, v2)
}
\arguments{
\item{v1}{First vector or element}

\item{v2}{Second vector or element}
}
\value{
The equality between both vectors.
}
\description{
The base-R function `==` is not working in an intended
  way for NAs and boolean. This function fixes this.
}
\examples{
\dontrun{
  dt <-
    data.table::data.table(
      a = c(TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, NA, NA, NA),
      b = c(TRUE, FALSE, NA, TRUE, FALSE, NA, TRUE, FALSE, NA)
    )
  dt[, "classic_result" := get("a") == get("b")]
  dt[, "result_expected" := equals2(get("a"), get("b"))]
  dt
  ## This is the result:
  # a     b classic_result result_expected
  # 1:  TRUE  TRUE           TRUE            TRUE
  # 2:  TRUE FALSE          FALSE           FALSE
  # 3:  TRUE    NA             NA           FALSE
  # 4: FALSE  TRUE          FALSE           FALSE
  # 5: FALSE FALSE           TRUE            TRUE
  # 6: FALSE    NA             NA           FALSE
  # 7:    NA  TRUE             NA           FALSE
  # 8:    NA FALSE             NA           FALSE
  # 9:    NA    NA             NA            TRUE
}

}
\references{
<http://www.cookbook-r.com/Manipulating_data/Comparing_vectors_or_factors_with_NA/>
}
