% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_hP.R
\name{summary.glm_hP}
\alias{summary.glm_hP}
\alias{print.summary.glm_hP}
\title{Summarizing hyper-Poisson Fits}
\usage{
\method{summary}{glm_hP}(object, ...)

\method{print}{summary.glm_hP}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{"glm_hP"}, usually, a result of a call
to \code{glm.hP}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.glm_hP"}, usually, a result of a
call to \code{summary.glm_hP}.}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If \code{TRUE}, \sQuote{significance stars}
    are printed for each coefficient.}
}
\description{
These functions are all methods for class \code{"glm_hP"} or
\code{summary.glm_hP} objects.
}
\examples{
## Fit a hyper-Poisson model

Bids$size.sq <- Bids$size ^ 2
fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)

## Obtain a summary of the fitted model

summary(fit)
}
