\name{IprSam}
\alias{IprSam}
\title{Signed Area Measure for Item parameter replication}
\usage{
IprSam(itemParameterList, irtModel = "2pl", subdivisions = 5000,
  logistic = TRUE)
}
\arguments{
  \item{itemParameterList}{A list where each element is a
  list containing "focal" and "reference" item Parameters.
  Item parameters are assumed to be on the same scale. Item
  parameters for each group should be a matrix with nrow
  equal to the number of items.}

  \item{irtModel}{A string stating the irtModel to be used.
  Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

  \item{subdivisions}{A numeric value indicating the number
  of subdivisions for numerical integration.}

  \item{logistic}{A logical value stating if the IRT model
  will use the logistic or the normal metric. Defaults to
  using the logistic metric by fixing the D constant to 1.
  If FALSE the constant is set to 1.702 so that the normal
  metric is used.}
}
\value{
sam A numeric matrix with the Signed Area Measure values
for all the item parameter in each set of itemParameterList
}
\description{
Calculates Raju's Signed Area Measure index on a list of
item parameters such as those produced by the Ipr function
}
\examples{
# # Not run
# #
# # data(dichotomousItemParameters)
# # threePlAse <- list()
# # threePlAse[['focal']] <- AseIrt(itemParameters = dichotomousItemParameters[['focal']],
# #                                 logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlAse[['reference']] <- AseIrt(itemParameters = dichotomousItemParameters[['reference']],
# #                                     logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlIpr <- Ipr(itemParameters = dichotomousItemParameters, itemCovariances = threePlAse,
# #                   nReplicates = 1000)
# # threePlSamIpr <- IprSam(itemParameterList = threePlIpr, irtModel = '3pl', logistic = TRUE)
}
\author{
Victor H. Cervantes <vcervantes at icfes.gov.co>
<vhcervantesb at unal.edu.co>
}
\references{
Raju, N. (1988). The area between two item characteristic
curves. Psychometricka, 53(4), 495--502.

Oshima, T., Raju, N. & Nanda, A. (2006). A new method for
assessing the statistical significance in the Differential
Functioning of Items and Tests (DFIT) framework. Journal of
educational measurement, 43(1), 1--17.
}

