% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{prep_targets}
\alias{prep_targets}
\title{Read tab or comma delimited target metadata file.}
\usage{
prep_targets(target_input, delim = "t")
}
\arguments{
\item{target_input}{Target data in tab separated format, assumes headers exist for each column.
Note that column names in the input count file must match row names in the input target metadata file.}

\item{delim}{Indicate if file is comma or tab delimited.  "t" indicated tab delimited and "c" indicates comma separated data.  Default: "t"}
}
\value{
This function will return a properly formatted targets data table based on a provided input file.
}
\description{
This function takes a targets metadata file and returns formatted data. Requires that init_data_paths() has been run.
}
\examples{
\dontrun{

#Read a tab-delimited text file as target metadata input.
myTargets <- prep_targets(target_input="master_count_data.txt", delim="t")

}
}
\seealso{
\code{\link{prep_counts}}, \code{\link{prep_dds_from_data}}, \code{\link{init_data_paths}}
}
\keyword{input}
\keyword{metadata}
\keyword{targets}
