% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro.R
\name{plot_dendro}
\alias{plot_dendro}
\title{Create dendrograms based on hierarchical clustering.}
\usage{
plot_dendro(filename = "dendro_plot.pdf", id_field, groupBy)
}
\arguments{
\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen").
Output will be written to /dendrograms/ directory.}

\item{id_field}{The unique sample ID field for your data.  Should correspond to a column in targets data.}

\item{groupBy}{A field in target meta data that you wish to cluster data by.}
}
\value{
This function does not return a value.
}
\description{
This function plots a dendrogram for the dataset as a whole using hierarchical clustering.  Metadata
can be applied to the dendrogram to examine how data cluster by different conditions. By examining
how data cluster, it is possible to identify patterns in the data and batch effects. For example,
creating a dendrogram that is grouped by the "case" condition in a case vs control experiment,
it would be possible to identify a strong effect in the overall dataset between the case and control
condition if most of the "case" conditions clustered strongly together. Batch effects can also be
identified in this way.  For instance, if samples were prepared at two different locations and this
information was incorporated into the metadata as a "batch" column, visualizing the data based on
batch data could indicate whether or not differences in the data are due to differences in the sample
prep location, rather than due to a biological effect, depending on how strongly the batches cluster.
}
\examples{
\dontrun{

#Plot a dendrogram based on an "infection" metadata field.
plot_dendro(filename="infection_dendro.pdf", "sample_id", "infection")

#Plot a dendrogram based on an "batch" metadata field.
plot_dendro(filename="batch_dendro.pdf", "sample_id", "batch")

}
}
\keyword{batch}
\keyword{cluster}
\keyword{dendrogram}
