% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ships_methods.R
\name{interpolate.ais.data}
\alias{interpolate.ais.data}
\title{Interpolate AIS data}
\usage{
interpolate.ais.data(aisdata)
}
\arguments{
\item{aisdata}{Data frame including the columns 'id' (ship identifier),
'time' (text string readable by \code{\link{as.POSIXct}}), 'x' and 'y'
(recorded ship position, unit: meters), and potentially additional columns}
}
\value{
Returns a data frame with the same columns as the input data. Tracks
that are too short to interpolate are omitted (with a warning)
}
\description{
Interpolates ship movement tracks obtained from Automatic
Identification System (AIS) data to obtain exactly one position per 30
minutes. The first and last position in the original track are omitted
unless minutes = 0 or 30 and seconds = 0.
}
\examples{
data(aisdata)
ais.testdata <- aisdata[c(12,14,16) ,]
plot(ais.testdata[c("x", "y")], asp=1, col="green", pch=16, xlim=c(780000, 837000))
lines(ais.testdata[c("x", "y")])
# Add 600 sec to 'time' to mis-allign with intervcal needed
ais.testdata$time <- format(as.POSIXlt(ais.testdata$time, tz = "UTC")+600)
text(ais.testdata[c("x", "y")]-900, ais.testdata$time, adj=0, cex=0.5)
interpolated <- interpolate.ais.data(ais.testdata)
points(interpolated[,c("x", "y")], col="red")
text(interpolated[c("x", "y")]-900, interpolated$time, adj=0, cex=0.5)
legend("bottomright", bty="n", pch=c(16, 1), col=c("green", "red"),
    legend=c("original positions", "interpolated"))
}
\seealso{
\code{\link{read.DeponsShips}} and \code{\link{ais.to.DeponsShips}}
}
