% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.Gamma}
\alias{plot.Gamma}
\title{Density Plot by Gamma kernel}
\usage{
\method{plot}{Gamma}(x, ...)
}
\arguments{
\item{x}{an object of class "BS"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Gamma Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- Gamma(y,200,h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
}
\references{
Chen, S. X. 2000. Probability density function estimation using Gamma kernels.  \emph{Annals of the Institute of Statistical Mathematics} \strong{52} (3), 471-480.
}
\seealso{
For further kernels see \code{\link{plot.Erlang}}, \code{\link{plot.BS}} and \code{\link{plot.LN}}. To calculate its estimated values see \code{\link{Gamma}} and for
MSE by using Gamma Kernel \code{\link{mseGamma}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
